/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.storage.impl.PGStorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.admin.SynchroPanelUI;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;

public class SynchroWizardLauncher
extends WizardUILancher<SynchroStep, SynchroUIModel, SynchroPanelUI> {
    private static final Log log = LogFactory.getLog(SynchroWizardLauncher.class);
    protected Component parent;

    public SynchroWizardLauncher(JAXXContext context, String title, String tip, ImageIcon icon) {
        super(context, SynchroPanelUI.class, SynchroUIModel.class, title, tip, icon);
    }

    protected void start(SynchroPanelUI ui) {
        super.start((WizardUI)ui);
        ObserveMainUI mainUI = ObserveContext.getObserveMainUI();
        String title = (String)ui.getClientProperty("title");
        String tip = (String)ui.getClientProperty("tip");
        ImageIcon icon = (ImageIcon)ui.getClientProperty("icon");
        if (mainUI == null) {
            JDialog dialog = new JDialog();
            dialog.setSize(650, 800);
            dialog.setTitle(I18n._((String)title));
            dialog.setContentPane(ui);
            if (icon != null) {
                dialog.setIconImage(icon.getImage());
            }
            dialog.setDefaultCloseOperation(2);
            dialog.setAlwaysOnTop(true);
            this.parent = dialog;
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("closing dialog " + e.getWindow().getName()));
                    }
                    if (((SynchroPanelUI)SynchroWizardLauncher.this.ui).getModel().getModelState() != WizardOperationState.CANCELED) {
                        log.info((Object)("cancel panel from dialog !" + e.getWindow().getName()));
                        ((SynchroPanelUI)SynchroWizardLauncher.this.ui).cancel();
                    }
                }
            });
            dialog.setVisible(true);
        } else {
            JXTitledPanel panel = mainUI.getSynchroWizard();
            panel.setTitle(I18n._((String)title));
            panel.setToolTipText(I18n._((String)tip));
            panel.setContentContainer((Container)ui);
            mainUI.setContextValue(ui.getModel());
            this.parent = mainUI;
            mainUI.setMode(ObserveUIMode.SYNCHRO);
        }
    }

    protected void doAction(SynchroPanelUI ui) {
        log.info((Object)this);
    }

    protected void doCancel(SynchroPanelUI ui) {
        log.info((Object)this);
    }

    protected void doClose(SynchroPanelUI ui, boolean wasCanceled) {
        log.info((Object)((Object)((Object)this) + ", was canceled ? " + wasCanceled));
        if (this.parent instanceof ObserveMainUI) {
            ObserveMainUI mainUI = (ObserveMainUI)this.parent;
            boolean needReload = false;
            SynchroUIModel uiModel = ui.getModel();
            needReload = !wasCanceled && uiModel.isLocalServiceNeedSave();
            StorageService<?> previousService = uiModel.getPreviousService();
            if (needReload && previousService != null) {
                needReload = previousService instanceof H2StorageService;
            }
            try {
                if (uiModel.getSynchroService() != null) {
                    uiModel.getSynchroService().doClose(false);
                }
            }
            catch (StorageServiceException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (uiModel.getReferentielService() != null) {
                    uiModel.getReferentielService().doClose(false);
                }
            }
            catch (StorageServiceException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (uiModel.getLocalService() != null) {
                    uiModel.getLocalService().doClose(false);
                }
            }
            catch (StorageServiceException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (previousService != null && previousService instanceof PGStorageService) {
                mainUI.setMode(ObserveUIMode.DB);
                mainUI.getTreeHelper().selectInitialNode(mainUI);
                return;
            }
            ObserveContext context = ObserveContext.get();
            ObserveConfig config = ObserveContext.getConfig();
            ObserveContext.runAction("init main database", (Object)context, "initStorage", new Object[]{config, mainUI, false});
        } else {
            JDialog dialog = (JDialog)this.parent;
            if (dialog.isVisible()) {
                log.info((Object)"dispose ui! ");
                dialog.dispose();
            }
        }
    }
}

