/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.GPSAbleTableModel;
import fr.ird.observe.ui.admin.GPSActiviteTableModel;
import fr.ird.observe.ui.admin.MareeToExportTableModel;
import fr.ird.observe.ui.admin.ObsoleteEntityTableModel;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.SynchroUIThread;
import fr.ird.observe.ui.admin.tabs.AbstractSynchroTabPanelUI;
import fr.ird.observe.ui.admin.tabs.ConfigSynchroPanelUI;
import fr.ird.observe.ui.admin.tabs.ExportDataPanelUI;
import fr.ird.observe.ui.admin.tabs.ImportGPSPanelUI;
import fr.ird.observe.ui.admin.tabs.SaveLocalPanelUI;
import fr.ird.observe.ui.admin.tabs.ShowResumePanelUI;
import fr.ird.observe.ui.admin.tabs.SynchronizeReferentielPanelUI;
import fr.ird.observe.ui.admin.tabs.ValidateDataPanelUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.swing.renderer.BooleanCellRenderer;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class SynchroPanelUI
extends JPanel
implements JAXXHelpUI<JAXXHelpBroker>,
WizardUI<SynchroStep, SynchroUIModel>,
JAXXObject {
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_CANCEL_ACTION_VISIBLE = "cancelAction.visible";
    public static final String BINDING_CLOSE_ACTION_VISIBLE = "closeAction.visible";
    public static final String BINDING_CLOSE_ON_CANCELED_OR_FAILED_ACTION_VISIBLE = "closeOnCanceledOrFailedAction.visible";
    public static final String BINDING_CONFIG_BLOCK_LAYER_UI_BLOCK = "configBlockLayerUI.block";
    public static final String BINDING_NEXT_ACTION_ENABLED = "nextAction.enabled";
    public static final String BINDING_NEXT_ACTION_VISIBLE = "nextAction.visible";
    public static final String BINDING_OPERATION_BLOCK_LAYER_UI_BLOCK = "operationBlockLayerUI.block";
    public static final String BINDING_PREVIOUS_ACTION_ENABLED = "previousAction.enabled";
    public static final String BINDING_PREVIOUS_ACTION_VISIBLE = "previousAction.visible";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAM1XzW8bRRSfuHFC4pR+fyBacEIJLmo3rQQ9UCHqOutmK8eOvHZbmkMY707sLeudZWc2tusW8Qdw4E+AK+KCxI0T4sCZQy+IfwEhDlwRb2bXXttZ20FKW5J4Y837mPd+7+3vzXz3B0oyDy0/wu224vkOt5pEuZt98KBUe0QMvk6Y4Vkupx4KfmYSKLGNUmZ/nXH01nZBmK+F5ms52nSpQ5wB65sFtMh4xyasQQjn6OKwhcHYmt4X32y7vtfz2g8qzuvXf/2Z+Mr84psEQm0XojsNqaSnWUWZzBZQwjI5Ogk77eE1Gzt1CMOznDrEe1Ss5WzMWBE3yWfoczRfQHMu9sAZRysHT1n6kPZtl6Ml1nGMhke3sENsjlZ3PcXyTIXWGPH2iOJbCjablqPoA2pVzXWlhzkOfw2PYAj6nSmWVa0iNSPT4zWfdW7b1Pi0gDvEq2qQxhBYrAWpK1IDvoRKkf0Z6hIPc4s6g06E8ESkdNKgzq5Vn6CxdCmHPRNk1OfXODolcFZwiyvR8kC6uVIxr93h6Pq4dDmuMSiz2HQYM+Fhoe/onP5xMbdRLhW1h+pOWc2rZbVY0dQCRx9M9Bz6dKzHpEx2iai+RezYLY7eyxa09WxF3YFHlqNrEx3fw7ZlYk7WMcex7ha1za1SubJzZ0vn6OpEXxp0n8dBMd6Rnr2n7hRKuWxhmiMd75ECNXB8gin1gYwoSE+Z6Elti5DGJpfSN0r3oQ56dVOd5kpv0FaZML9JYl3NCiUosOijdtjDdyu4ViOm0B9WnseGaGDQPx/T+mBljxgsGdgxiJ2VZmG39ne57XNOHaF5vW9w0bApIyUnJ+2IWfLy2IL/gQehdGPYICUNxopfdT2yZ1GfjdVYdEib75d66PWhFIFklYhkIxac2UZJz4dlwGR7Py+XQRQw8vkRRhYOpfSfs6ee/fj7D/keDadg7zOxqgNTBOjR9QSjwPsEWx8LONjnlr22id2b22iBAXxGMGIuxASmh2IIDvY7IWlEmCsbmDXARXL+t59+PvvJr0dQIo8WbYrNPBb6GloQHMoa1Dbb7ke3ZERLrVfgeRw+CSAdW7IQR6e7Dmmlb1PPJF7ATJnLTzlK7jSIDVx+vrsCndrE0Kg1anaUkNpXnrYBrQsxaPVDri388vcp/ftbPcRmIIPXxqpHqCUfojnLsS2HyNEVTqXYUZVyGfFNGk2fuHmERgaSGzLvunxu7APnCLBcLZwPOWrDG47e71a1TezgOvGUOuFyNbMyMkSUIaMVCaJc4ujL7n3rMTB/VZQOGwZxuc6BF1mmSU1iC5+b4otczFy+kg7US71ZJNeVXLaYUwvq+hixXs3lVF0fK89nNTAWYc37jGiGeNWTu9hmpO0LJIqyRuLbFooZpC8BtnPd5QAfi93HDLLwODEzB80gfpS/hDTq3bgs0k+epA+zKw4KS8zhZRomgi5qkiA4ercbUEXAMx3FgPMXJ2rT5Z1AkLlxRf4OksjFeBJRGCeuYJL9UcqBd4BazbeIVW/wNkcz18Fq17LhwDlbo7wR7f7mmN2DMRm/f2+GTgshKUKF0STaLRzsgaUSzFTwtGcxC0buCAt4RNw9XiYLLAaBBv0y1ws3xSm1K5ZbkUktjyTVgy7QVjjcAvowr06EOTSJR3voAHJwyE+PQi4OGYOI2y+Cd8cgOkvaFh/FMx0XcR+pITjfngKnsIxHc/Lp7BDh3ToUePsd+z+CcPC8Og0wceImjjhVw411udtPfSs80+pAckD3yx+mHd+2n/bhXRlJpE45VXoHYaBGmDeDYH/7ItijXC0WteKdw+WWYy2pfLWX22hFV6cDMVzXzOS69kzjSzty1/hP1X0vqm4RQh+ubHp1Nd0b9PLiG4ijgr8Rl6e41zyvYk+u5vMZJKmw2I5MebjQsR0fATBc5EuTiyzM4gs8cFWE4v4LPfRx8/0TAAA=";
    protected static final Log log = LogFactory.getLog(SynchroPanelUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected ConfigSynchroPanelUI CONFIG;
    protected ExportDataPanelUI EXPORT_DATA;
    protected ImportGPSPanelUI IMPORT_GPS;
    protected SaveLocalPanelUI SAVE_LOCAL;
    protected ShowResumePanelUI SHOW_RESUME;
    protected SynchronizeReferentielPanelUI SYNCHRONIZE_REFERENTIEL;
    protected ValidateDataPanelUI VALIDATE_DATA;
    protected Table actions;
    protected BlockingLayerUI busyBlockLayerUI;
    protected JButton cancelAction;
    protected JButton closeAction;
    protected JButton closeOnCanceledOrFailedAction;
    protected BlockingLayerUI configBlockLayerUI;
    protected JButton nextAction;
    protected BlockingLayerUI operationBlockLayerUI;
    protected JButton previousAction;
    protected SynchroPanelUI synchroPanel = this;
    protected JTabbedPane tabs;
    protected SynchroUIThread thread;
    private CardLayout $CardLayout0;
    private SynchroUIModel model;
    private boolean contextInitialized;

    public SynchroPanelUI(JAXXContext parentContext, String title, String tip, ImageIcon icon) {
        this.$initialize();
        this.putClientProperty("title", title);
        this.putClientProperty("tip", tip);
        this.putClientProperty("imageIcon", icon);
        UIHelper.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)UIHelper.newContextEntryDef(SynchroUIModel.class));
        UIHelper.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.model = this.getContextValue(SynchroUIModel.class);
        JAXXUtil.assignment((Object)((Object)this.model), (String)"model", (JAXXObject)this);
        this.contextInitialized = true;
        JAXXUtil.assignment((boolean)true, (String)"contextInitialized", (JAXXObject)this);
        this.$initialize();
    }

    public void start() {
        this.getThread().start();
        this.model.start();
        this.setVisible(true);
    }

    public void apply() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Runnable action = SynchroPanelUI.this.getContextValue(Runnable.class, "apply");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    SynchroPanelUI.this.dispose();
                }
            }
        });
    }

    public void cancel() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Runnable action = SynchroPanelUI.this.getContextValue(Runnable.class, "cancel");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    SynchroPanelUI.this.dispose();
                }
            }
        });
    }

    public void dispose() {
        if (this.thread.isAlive()) {
            this.thread.cancel();
        }
    }

    public SynchroUIModel getModel() {
        return this.model;
    }

    public SynchroStep getSelectedStep() {
        int index = this.tabs.getSelectedIndex();
        AbstractSynchroTabPanelUI c = null;
        if (index > -1) {
            c = (AbstractSynchroTabPanelUI)this.tabs.getComponentAt(index);
        }
        SynchroStep result = c == null ? null : c.getStep();
        return result;
    }

    public AbstractSynchroTabPanelUI getStepUI(SynchroStep step) {
        if (step != null) {
            return (AbstractSynchroTabPanelUI)this.getObjectById(step.name());
        }
        return null;
    }

    public AbstractSynchroTabPanelUI getStepUI(int stepIndex) {
        if (stepIndex > this.tabs.getTabCount()) {
            return null;
        }
        return (AbstractSynchroTabPanelUI)this.tabs.getComponentAt(stepIndex);
    }

    public AbstractSynchroTabPanelUI getSelectedStepUI() {
        SynchroStep step = this.getSelectedStep();
        AbstractSynchroTabPanelUI ui = this.getStepUI(step);
        return ui;
    }

    public void blockOperations() {
        this.model.setValueAdjusting(true);
        for (SynchroStep op : SynchroStep.values()) {
            JCheckBox comp = (JCheckBox)this.CONFIG.getObjectById(op.name());
            if (comp == null || this.model.getOperations().contains((Object)op)) continue;
            comp.setVisible(false);
        }
        this.operationBlockLayerUI.setBlock(true);
        this.model.setValueAdjusting(false);
    }

    public void onWasStarted() {
        this.getTabs().setTitleAt(0, I18n._((String)"observe.synchro.step.progression"));
    }

    public void onModelStateChanged(WizardOperationState newState) {
        log.trace((Object)newState);
        AbstractSynchroTabPanelUI selected = this.getSelectedStepUI();
        boolean busy = WizardUtil.acceptStates((WizardOperationState)newState, (WizardOperationState[])new WizardOperationState[]{WizardOperationState.RUNNING});
        SwingUtil.TabbedPaneIterator itr = UIHelper.newTabbedPaneIterator((JTabbedPane)this.getTabs());
        if (busy) {
            while (itr.hasNext()) {
                Component tab = (Component)itr.next();
                this.tabs.setEnabledAt(itr.getIndex() - 1, tab == selected);
            }
        } else {
            boolean[] accessibleSteps = this.model.getAccessibleSteps();
            while (itr.hasNext()) {
                int index = itr.getIndex();
                this.tabs.setEnabledAt(index, accessibleSteps[index]);
                itr.next();
            }
            if (this.model.isShowResume()) {
                this.tabs.setEnabledAt(accessibleSteps.length - 1, true);
            }
        }
    }

    public void onOperationStateChanged(SynchroStep step, WizardOperationState newState) {
        log.trace((Object)((Object)((Object)step) + " - " + newState));
        AbstractSynchroTabPanelUI selected = this.getStepUI(step);
        int index = this.tabs.indexOfComponent(selected);
        if (index > -1) {
            this.tabs.setIconAt(index, selected.getTabIcon(newState));
        }
        if (step == selected.getStep()) {
            selected.updateState(newState);
        }
    }

    public void onStepChanged(SynchroStep newStep) {
        int index;
        log.trace((Object)newStep);
        AbstractSynchroTabPanelUI c = this.getStepUI(newStep);
        if (c == this.SAVE_LOCAL) {
            this.SAVE_LOCAL.updateText();
        }
        if (c == this.SHOW_RESUME) {
            this.SHOW_RESUME.updateText(this.CONFIG.getGlobalProgression().getText());
        }
        if ((index = this.tabs.indexOfComponent(c)) > -1 && this.tabs.getSelectedIndex() != index) {
            this.tabs.setSelectedIndex(index);
        }
    }

    public void onStepsChanged(SynchroStep[] steps) {
        log.trace((Object)Arrays.toString((Object[])steps));
        this.model.setValueAdjusting(true);
        while (this.tabs.getTabCount() > 1) {
            this.tabs.remove(this.tabs.getTabCount() - 1);
        }
        int max = steps.length;
        for (int i = 0; i < max; ++i) {
            SynchroStep step = steps[i];
            AbstractSynchroTabPanelUI c = this.getStepUI(step);
            String title = I18n._((String)step.getLabel());
            String tip = I18n._((String)step.getDescription());
            this.tabs.addTab(title, null, c, tip);
            ((Component)c).setEnabled(i == 0);
        }
        this.model.setValueAdjusting(false);
    }

    public JAXXHelpBroker getBroker() {
        return this.getContextValue(JAXXHelpBroker.class);
    }

    void $afterCompleteSetup() {
        this.setContextValue(this.thread);
        WizardUtil.installWizardUIListeners((WizardUI)this);
        WizardUtil.addTraceLogListener((Log)log, (WizardModel)this.getModel());
        this.model.init((JAXXContext)this);
        for (SynchroStep step : SynchroStep.values()) {
            AbstractSynchroTabPanelUI c = this.getStepUI(step);
            JPanel content = c.getContent();
            UIHelper.getLayer((JComponent)content).setUI((LayerUI)this.busyBlockLayerUI);
        }
        UIHelper.getLayer((JComponent)this.CONFIG.getOperations()).setUI((LayerUI)this.operationBlockLayerUI);
        UIHelper.getLayer((JComponent)this.CONFIG.getConfig()).setUI((LayerUI)this.configBlockLayerUI);
        UIHelper.getLayer((JComponent)this.CONFIG.getContent()).setUI(null);
        UIHelper.getLayer((JComponent)this.SHOW_RESUME.getContent()).setUI(null);
        final JTable table = this.SYNCHRONIZE_REFERENTIEL.getObsoleteRefs();
        table.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table, (int)0, (int)20);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.synchro.table.obsolete.entity.select"), I18n.n_((String)"observe.synchro.table.obsolete.entity.select.tip"), I18n.n_((String)"observe.synchro.table.obsolete.entity.label"), I18n.n_((String)"observe.synchro.table.obsolete.entity.label.tip")});
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        this.SYNCHRONIZE_REFERENTIEL.setContextValue(renderer, "defaultTableRenderer");
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, TopiaEntityRef.class));
        UIHelper.setTableColumnEditor((JTable)table, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table.convertColumnIndexToModel(colIndex)) == 0) {
                    ObsoleteEntityTableModel model;
                    boolean oldValue = (model = (ObsoleteEntityTableModel)table.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
        final JTable table2 = this.IMPORT_GPS.getActivites();
        table2.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)0, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)2, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)3, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)4, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table2, (int)5, (int)75);
        UIHelper.setI18nTableHeaderRenderer((JTable)table2, (String[])new String[]{I18n.n_((String)"observe.synchro.table.importGPS.activite.select"), I18n.n_((String)"observe.synchro.table.importGPS.activite.select.tip"), I18n.n_((String)"observe.synchro.table.importGPS.activite.label"), I18n.n_((String)"observe.synchro.table.importGPS.activite.label.tip"), I18n.n_((String)"observe.synchro.table.importGPS.activite.quadrant"), I18n.n_((String)"observe.synchro.table.importGPS.activite.quadrant.tip"), I18n.n_((String)"observe.synchro.table.importGPS.activite.latitude"), I18n.n_((String)"observe.synchro.table.importGPS.activite.latitude.tip"), I18n.n_((String)"observe.synchro.table.importGPS.activite.longitude"), I18n.n_((String)"observe.synchro.table.importGPS.activite.longitude.tip"), I18n.n_((String)"observe.synchro.table.importGPS.activite.vitesse"), I18n.n_((String)"observe.synchro.table.importGPS.activite.vitesse.tip")});
        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer();
        this.IMPORT_GPS.setContextValue(renderer2, "defaultTableRenderer");
        DefaultTableCellRenderer renderer3 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text;
                int modelColumn = table.convertColumnIndexToModel(column);
                int modelRow = table.convertRowIndexToModel(row);
                Object o = ((GPSActiviteTableModel)table.getModel()).getValueAt(modelRow, modelColumn);
                String text2 = text = ((GPSActiviteTableModel)table.getModel()).getTextValueAt(modelRow, modelColumn);
                if (o == null) {
                    text2 = I18n._((String)"observe.common.undefined.tip");
                }
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                String tip = null;
                switch (modelColumn) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tip = I18n._((String)"observe.common.activite") + " : " + text;
                        break;
                    }
                    case 2: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.quadrant.tip") + " : " + text2;
                        break;
                    }
                    case 3: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.latitude.tip") + " : " + text2;
                        break;
                    }
                    case 4: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.longitude.tip") + " : " + text2;
                        break;
                    }
                    case 5: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.vitesse.tip") + " : " + text2;
                    }
                }
                c.setToolTipText(tip);
                return c;
            }
        };
        UIHelper.setTableColumnRenderer((JTable)table2, (int)0, (TableCellRenderer)new BooleanCellRenderer((TableCellRenderer)renderer2));
        UIHelper.setTableColumnRenderer((JTable)table2, (int)1, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)2, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)3, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)4, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnRenderer((JTable)table2, (int)5, (TableCellRenderer)renderer3);
        UIHelper.setTableColumnEditor((JTable)table2, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table2.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table2.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table2.convertColumnIndexToModel(colIndex)) == 0) {
                    GPSActiviteTableModel model;
                    boolean oldValue = (model = (GPSActiviteTableModel)table2.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
        JTable table3 = this.IMPORT_GPS.getActiviteDetail();
        UIHelper.setI18nTableHeaderRenderer((JTable)table3, (String[])new String[]{I18n.n_((String)"observe.synchro.table.importGPS.data.label"), I18n.n_((String)"observe.synchro.table.importGPS.data.label.tip"), I18n.n_((String)"observe.synchro.table.importGPS.computed.label"), I18n.n_((String)"observe.synchro.table.importGPS.computed.label.tip")});
        DefaultTableCellRenderer renderer4 = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text;
                int modelColumn = table.convertColumnIndexToModel(column);
                int modelRow = table.convertRowIndexToModel(row);
                GPSAbleTableModel model = (GPSAbleTableModel)table.getModel();
                Object o = model.getValueAt(modelRow, modelColumn);
                String text2 = text = model.getTextValueAt(modelRow, modelColumn);
                if (o == null) {
                    text2 = I18n._((String)"observe.common.undefined.tip");
                }
                JComponent c = (JComponent)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                String tip = null;
                switch (modelRow) {
                    case 0: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.quadrant.tip") + " : " + text2;
                        break;
                    }
                    case 1: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.latitude.tip") + " : " + text2;
                        break;
                    }
                    case 2: {
                        tip = I18n._((String)"observe.synchro.table.importGPS.activite.longitude.tip") + " : " + text2;
                    }
                }
                c.setToolTipText(tip);
                return c;
            }
        };
        UIHelper.setTableColumnRenderer((JTable)table3, (int)0, (TableCellRenderer)renderer4);
        UIHelper.setTableColumnRenderer((JTable)table3, (int)1, (TableCellRenderer)renderer4);
        final JTable table4 = this.EXPORT_DATA.getMarees();
        table4.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)0, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table4, (int)3, (int)20);
        DefaultTableCellRenderer renderer5 = new DefaultTableCellRenderer();
        UIHelper.setI18nTableHeaderRenderer((JTable)table4, (String[])new String[]{I18n.n_((String)"observe.synchro.table.exportData.selected"), I18n.n_((String)"observe.synchro.table.exportData.selected.tip"), I18n.n_((String)"observe.synchro.table.exportData.programme.label"), I18n.n_((String)"observe.synchro.table.exportData.programme.label.tip"), I18n.n_((String)"observe.synchro.table.exportData.maree.label"), I18n.n_((String)"observe.synchro.table.exportData.maree.label.tip"), I18n.n_((String)"observe.synchro.table.exportData.exist.label"), I18n.n_((String)"observe.synchro.table.exportData.exist.label.tip")});
        UIHelper.setTableColumnRenderer((JTable)table4, (int)0, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer5));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, Programme.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer5, Maree.class));
        UIHelper.setTableColumnRenderer((JTable)table4, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer5));
        UIHelper.setTableColumnEditor((JTable)table4, (int)0, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor((boolean)false));
        table4.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colIndex = table4.getTableHeader().columnAtPoint(e.getPoint());
                if ((colIndex = table4.convertColumnIndexToModel(colIndex)) == 0) {
                    MareeToExportTableModel model;
                    boolean oldValue = (model = (MareeToExportTableModel)table4.getModel()).isSelectAll();
                    model.setSelectAll(!oldValue);
                }
            }
        });
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public SynchroPanelUI() {
        this.$initialize();
    }

    public SynchroPanelUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        this.getThread().cancel();
    }

    public void doActionPerformed__on__closeAction(ActionEvent event) {
        this.apply();
    }

    public void doActionPerformed__on__closeOnCanceledOrFailedAction(ActionEvent event) {
        this.cancel();
    }

    public void doActionPerformed__on__nextAction(ActionEvent event) {
        this.model.gotoNextStep();
    }

    public void doActionPerformed__on__previousAction(ActionEvent event) {
        this.model.gotoPreviousStep();
    }

    public void doStateChanged__on__tabs(ChangeEvent event) {
        if (!this.model.isValueAdjusting()) {
            this.model.gotoStep((WizardStep)this.getSelectedStep());
        }
    }

    public Table getActions() {
        return this.actions;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return this.busyBlockLayerUI;
    }

    public ConfigSynchroPanelUI getCONFIG() {
        return this.CONFIG;
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getCloseAction() {
        return this.closeAction;
    }

    public JButton getCloseOnCanceledOrFailedAction() {
        return this.closeOnCanceledOrFailedAction;
    }

    public BlockingLayerUI getConfigBlockLayerUI() {
        return this.configBlockLayerUI;
    }

    public ExportDataPanelUI getEXPORT_DATA() {
        return this.EXPORT_DATA;
    }

    public ImportGPSPanelUI getIMPORT_GPS() {
        return this.IMPORT_GPS;
    }

    public JButton getNextAction() {
        return this.nextAction;
    }

    public BlockingLayerUI getOperationBlockLayerUI() {
        return this.operationBlockLayerUI;
    }

    public JButton getPreviousAction() {
        return this.previousAction;
    }

    public SaveLocalPanelUI getSAVE_LOCAL() {
        return this.SAVE_LOCAL;
    }

    public ShowResumePanelUI getSHOW_RESUME() {
        return this.SHOW_RESUME;
    }

    public SynchronizeReferentielPanelUI getSYNCHRONIZE_REFERENTIEL() {
        return this.SYNCHRONIZE_REFERENTIEL;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public SynchroUIThread getThread() {
        return this.thread;
    }

    public ValidateDataPanelUI getVALIDATE_DATA() {
        return this.VALIDATE_DATA;
    }

    public void registerHelpId(JAXXHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    public void showHelp(String helpId) {
        this.getBroker().showHelp((JAXXContext)this, helpId);
    }

    protected CardLayout get$CardLayout0() {
        return this.$CardLayout0;
    }

    protected void addChildrenToActions() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.actions.add((Component)this.cancelAction, (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.closeOnCanceledOrFailedAction, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.closeAction, (Object)new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.previousAction, (Object)new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.actions.add((Component)this.nextAction, (Object)new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSynchroPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add(this.CONFIG);
        this.add(this.SYNCHRONIZE_REFERENTIEL);
        this.add(this.VALIDATE_DATA);
        this.add(this.IMPORT_GPS);
        this.add(this.SAVE_LOCAL);
        this.add(this.EXPORT_DATA);
        this.add(this.SHOW_RESUME);
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.actions, "South");
    }

    protected void createActions() {
        this.actions = new Table();
        this.$objectMap.put("actions", this.actions);
        this.actions.setName("actions");
        this.actions.putClientProperty((Object)"help", (Object)"ui.main.body.synchro.action");
    }

    protected void createBusyBlockLayerUI() {
        this.busyBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("busyBlockLayerUI", this.busyBlockLayerUI);
        this.busyBlockLayerUI.setUseIcon(false);
    }

    protected void createCONFIG() {
        this.CONFIG = new ConfigSynchroPanelUI(this);
        this.$objectMap.put("CONFIG", this.CONFIG);
        this.CONFIG.setName("CONFIG");
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n._((String)"observe.action.cancel"));
        this.cancelAction.setToolTipText(I18n._((String)"observe.action.synchro.cancel.tip"));
        this.cancelAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancelAction"));
        this.cancelAction.putClientProperty("help", "ui.main.body.synchro.action.cancel");
    }

    protected void createCloseAction() {
        this.closeAction = new JButton();
        this.$objectMap.put("closeAction", this.closeAction);
        this.closeAction.setName("closeAction");
        this.closeAction.setText(I18n._((String)"observe.action.close"));
        this.closeAction.setToolTipText(I18n._((String)"observe.action.close.synchro.tip"));
        this.closeAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__closeAction"));
        this.closeAction.putClientProperty("help", "ui.main.body.synchro.action.close");
    }

    protected void createCloseOnCanceledOrFailedAction() {
        this.closeOnCanceledOrFailedAction = new JButton();
        this.$objectMap.put("closeOnCanceledOrFailedAction", this.closeOnCanceledOrFailedAction);
        this.closeOnCanceledOrFailedAction.setName("closeOnCanceledOrFailedAction");
        this.closeOnCanceledOrFailedAction.setText(I18n._((String)"observe.action.close"));
        this.closeOnCanceledOrFailedAction.setToolTipText(I18n._((String)"observe.action.close.synchro.tip"));
        this.closeOnCanceledOrFailedAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__closeOnCanceledOrFailedAction"));
        this.closeOnCanceledOrFailedAction.putClientProperty("help", "ui.main.body.synchro.action.close");
    }

    protected void createConfigBlockLayerUI() {
        this.configBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("configBlockLayerUI", this.configBlockLayerUI);
        this.configBlockLayerUI.setUseIcon(false);
    }

    protected void createEXPORT_DATA() {
        this.EXPORT_DATA = new ExportDataPanelUI(this);
        this.$objectMap.put("EXPORT_DATA", this.EXPORT_DATA);
        this.EXPORT_DATA.setName("EXPORT_DATA");
    }

    protected void createIMPORT_GPS() {
        this.IMPORT_GPS = new ImportGPSPanelUI(this);
        this.$objectMap.put("IMPORT_GPS", this.IMPORT_GPS);
        this.IMPORT_GPS.setName("IMPORT_GPS");
    }

    protected void createNextAction() {
        this.nextAction = new JButton();
        this.$objectMap.put("nextAction", this.nextAction);
        this.nextAction.setName("nextAction");
        this.nextAction.setText(I18n._((String)"observe.action.goto.next.stage"));
        this.nextAction.setToolTipText(I18n._((String)"observe.action.goto.next.stage.tip"));
        this.nextAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__nextAction"));
        this.nextAction.putClientProperty("help", "ui.main.body.synchro.action.next");
    }

    protected void createOperationBlockLayerUI() {
        this.operationBlockLayerUI = new BlockingLayerUI();
        this.$objectMap.put("operationBlockLayerUI", this.operationBlockLayerUI);
        this.operationBlockLayerUI.setUseIcon(false);
    }

    protected void createPreviousAction() {
        this.previousAction = new JButton();
        this.$objectMap.put("previousAction", this.previousAction);
        this.previousAction.setName("previousAction");
        this.previousAction.setText(I18n._((String)"observe.action.goto.previous.stage"));
        this.previousAction.setToolTipText(I18n._((String)"observe.action.goto.previous.stage.tip"));
        this.previousAction.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__previousAction"));
        this.previousAction.putClientProperty("help", "ui.main.body.synchro.action.previous");
    }

    protected void createSAVE_LOCAL() {
        this.SAVE_LOCAL = new SaveLocalPanelUI(this);
        this.$objectMap.put("SAVE_LOCAL", this.SAVE_LOCAL);
        this.SAVE_LOCAL.setName("SAVE_LOCAL");
    }

    protected void createSHOW_RESUME() {
        this.SHOW_RESUME = new ShowResumePanelUI(this);
        this.$objectMap.put("SHOW_RESUME", this.SHOW_RESUME);
        this.SHOW_RESUME.setName("SHOW_RESUME");
    }

    protected void createSYNCHRONIZE_REFERENTIEL() {
        this.SYNCHRONIZE_REFERENTIEL = new SynchronizeReferentielPanelUI(this);
        this.$objectMap.put("SYNCHRONIZE_REFERENTIEL", this.SYNCHRONIZE_REFERENTIEL);
        this.SYNCHRONIZE_REFERENTIEL.setName("SYNCHRONIZE_REFERENTIEL");
    }

    protected void createTabs() {
        this.tabs = new JTabbedPane();
        this.$objectMap.put("tabs", this.tabs);
        this.tabs.setName("tabs");
        this.tabs.addChangeListener((ChangeListener)JAXXUtil.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this, (String)"doStateChanged__on__tabs"));
        this.tabs.putClientProperty("help", "ui.main.body.synchro.step");
    }

    protected void createThread() {
        this.thread = new SynchroUIThread((JAXXContext)this);
        this.$objectMap.put("thread", (Object)this.thread);
    }

    protected void createVALIDATE_DATA() {
        this.VALIDATE_DATA = new ValidateDataPanelUI(this);
        this.$objectMap.put("VALIDATE_DATA", this.VALIDATE_DATA);
        this.VALIDATE_DATA.setName("VALIDATE_DATA");
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToSynchroPanel();
        this.addChildrenToActions();
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.busyBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.operationBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.configBlockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        this.tabs.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.cancelAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"cancel"));
        this.closeOnCanceledOrFailedAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"exit"));
        this.closeAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"exit"));
        this.previousAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"wizard-previous"));
        this.nextAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"wizard-next"));
        JAXXHelpBroker _broker = this.getBroker();
        this.registerHelpId(_broker, this.synchroPanel, "ui.main.body.synchro");
        this.registerHelpId(_broker, this.tabs, "ui.main.body.synchro.step");
        this.registerHelpId(_broker, (Component)this.actions, "ui.main.body.synchro.action");
        this.registerHelpId(_broker, this.cancelAction, "ui.main.body.synchro.action.cancel");
        this.registerHelpId(_broker, this.closeOnCanceledOrFailedAction, "ui.main.body.synchro.action.close");
        this.registerHelpId(_broker, this.closeAction, "ui.main.body.synchro.action.close");
        this.registerHelpId(_broker, this.previousAction, "ui.main.body.synchro.action.previous");
        this.registerHelpId(_broker, this.nextAction, "ui.main.body.synchro.action.next");
        _broker.prepareUI((JAXXObject)this);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("synchroPanel", this);
        this.createThread();
        this.createBusyBlockLayerUI();
        this.createOperationBlockLayerUI();
        this.createConfigBlockLayerUI();
        this.$CardLayout0 = new CardLayout();
        this.$objectMap.put("$CardLayout0", this.$CardLayout0);
        this.createCONFIG();
        this.createSYNCHRONIZE_REFERENTIEL();
        this.createVALIDATE_DATA();
        this.createIMPORT_GPS();
        this.createSAVE_LOCAL();
        this.createEXPORT_DATA();
        this.createSHOW_RESUME();
        this.createTabs();
        this.createActions();
        this.createCancelAction();
        this.createCloseOnCanceledOrFailedAction();
        this.createCloseAction();
        this.createPreviousAction();
        this.createNextAction();
        this.setName("synchroPanel");
        this.setLayout(new BorderLayout());
        this.synchroPanel.putClientProperty("help", "ui.main.body.synchro");
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.busyBlockLayerUI.setBlock(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_OPERATION_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.operationBlockLayerUI.setBlock(!SynchroPanelUI.this.model.isWasStarted());
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CONFIG_BLOCK_LAYER_UI_BLOCK, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.configBlockLayerUI.setBlock(SynchroPanelUI.this.model.isWasStarted() || WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("wasStarted", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CANCEL_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.cancelAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CLOSE_ON_CANCELED_OR_FAILED_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.closeOnCanceledOrFailedAction.setVisible(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CLOSE_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.closeAction.setVisible(WizardUtil.acceptStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.SUCCESSED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_ENABLED, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.previousAction.setEnabled(SynchroPanelUI.this.model.getPreviousStep() != null);
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.previousAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.CANCELED, WizardOperationState.RUNNING, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_ENABLED, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.nextAction.setEnabled(SynchroPanelUI.this.model.getNextStep() != null && SynchroPanelUI.this.model.isValidStep());
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                SynchroPanelUI.this.addPropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.addPropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.nextAction.setVisible(WizardUtil.rejectStates((WizardOperationState)SynchroPanelUI.this.model.getModelState(), (WizardOperationState[])new WizardOperationState[]{WizardOperationState.RUNNING, WizardOperationState.CANCELED, WizardOperationState.SUCCESSED, WizardOperationState.FAILED}));
                }
            }

            public void removeDataBinding() {
                SynchroPanelUI.this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)this));
                if (SynchroPanelUI.this.model != null) {
                    SynchroPanelUI.this.model.removePropertyChangeListener("modelState", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

