/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.ObserveMain;
import fr.ird.observe.ReferentielLocaleEnum;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.SelectDataModel;
import fr.ird.observe.storage.StorageConfig;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.PGStorageConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.SynchroPanelUI;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroWizardLauncher;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentActions;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.StorageWizardLauncher;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIBuilder;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModelBuilder;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Resource;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler
implements JAXXHelpUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);
    final Runnable reloadApplicationCallback = new Runnable(){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload application");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUI ui = ObserveMainUIHandler.this.getUI((JAXXContext)context);
            ObserveMain.setReload(true);
            ObserveMainUIHandler.this.close(ui);
        }
    };
    final Runnable reloadUICallback = new Runnable(){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload ui");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUI ui = ObserveMainUIHandler.this.getUI((JAXXContext)context);
            ObserveConfig config = ui.getConfig();
            ObserveMainUIHandler.this.reloadUI(context, config);
        }
    };
    final Runnable reloadDBCallback = new Runnable(){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload db");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUIHandler.this.launchReloadStorage((JAXXContext)context);
        }
    };

    public ObserveMainUI initUI(ObserveContext rootContext, ObserveConfig config) {
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        SwingValidatorMessageTableModel errorModel = new SwingValidatorMessageTableModel();
        ObserveDecoratorProvider decoratorProvider = (ObserveDecoratorProvider)rootContext.getContextValue(ObserveDecoratorProvider.class);
        boolean reloadDecotrators = false;
        if (!config.getLocale().equals(I18n.getStore().getLanguage().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + config.getLocale()));
            }
            I18n.init((Locale)config.getLocale());
            reloadDecotrators = true;
        }
        if (!config.getDbLocale().equals(decoratorProvider.getReferentielLocale().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init db with locale " + config.getDbLocale()));
            }
            decoratorProvider.setReferentielLocale(ReferentielLocaleEnum.valueOf((Locale)config.getDbLocale()));
            reloadDecotrators = true;
        }
        if (reloadDecotrators) {
            if (log.isInfoEnabled()) {
                log.info((Object)"reload decorators");
            }
            decoratorProvider.reload();
        }
        JAXXInitialContext context = new JAXXInitialContext();
        context.add((Object)rootContext).add((Object)treeHelper).add((Object)errorModel);
        final ObserveMainUI ui = new ObserveMainUI((JAXXContext)context);
        ui.setUndecorated(config.isFullScreen());
        ObserveContext.setObserveMainUI(ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        ActionMap actionMap = ui.getRootPane().getActionMap();
        for (ObserveContentActions actionDef : ObserveContentActions.values()) {
            Action a = actionDef.createAction(ui);
            actionMap.put((Object)actionDef, a);
        }
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent source = (JComponent)e.getSource();
                NavigationTreeNode node = (NavigationTreeNode)source.getClientProperty("node");
                ui.getTreeHelper().selectNode((JAXXContext)ui, node);
            }
        };
        a.putValue("ShortDescription", I18n._((String)"observe.action.selectNode.tip"));
        actionMap.put("selectNode", a);
        return ui;
    }

    public void changeLanguage(ObserveMainUI mainUI, Locale newLocale) {
        ObserveConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void changeDbLanguage(ObserveMainUI mainUI, ReferentielLocaleEnum newLocale) {
        ObserveConfig config = mainUI.getConfig();
        config.setDbLocale(newLocale.getLocale());
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showGoUp(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
        if (p == null) {
            throw new IllegalStateException("could not find client property popup on component" + c);
        }
        p.show(c, 2, c.getHeight());
    }

    public void showGoDown(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
        if (p == null) {
            throw new IllegalStateException("could not find client property popup on component" + c);
        }
        p.show(c, 2, c.getHeight());
    }

    public void showStorageInfo(ObserveMainUI ui) {
        String text = ui.getConfig().isMainStorageOpened() ? ui.getDataContext().getStorage().toString() : I18n._((String)"observe.message.db.none.loaded");
        JOptionPane.showMessageDialog(ui, text, I18n._((String)"observe.title.storage.info"), 1);
    }

    public void launchImportFromFile(final JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new StorageWizardLauncher(rootContext, this.getUI(rootContext), I18n._((String)"observe.title.import.localDB")){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                StorageUIModel model = ui.getModel();
                model.setDbMode(DbMode.CREATE_LOCAL);
                model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                if (model.isLocalStorageExist()) {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                } else {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                }
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage(rootContext, ui.getModel());
            }
        }.start();
    }

    public void launchChangeStorage(final JAXXContext rootContext, final DbMode mode, String title) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new StorageWizardLauncher(rootContext, this.getUI(rootContext), title){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                StorageUIModel model = ui.getModel();
                if (mode != null) {
                    model.setDbMode(mode);
                    model.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE));
                }
                model.updateUniverse();
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage(rootContext, ui.getModel());
            }
        }.start();
    }

    public void launchExportLocalToFile(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new StorageBackupWizardLauncher(rootContext, this.getUI(rootContext), I18n._((String)"observe.title.save.localDB")).start();
    }

    public void launchExportRemoteToFile(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        StorageService<?> service = ObserveMainUIHandler.getStorage();
        if (!service.canReadData() || !service.canWriteData()) {
            UIHelper.askUser(null, I18n._((String)"observe.title.can.not.export.obstuna"), I18n._((String)"observe.storage.required.rw.on.data", (Object[])new Object[]{service}), 0, new Object[]{I18n._((String)"observe.choice.cancel")}, 0);
            return;
        }
        new StorageBackupWizardLauncher(rootContext, this.getUI(rootContext), I18n._((String)"observe.title.save.remoteDB")).start();
    }

    public void launchCloseStorage(JAXXContext context) {
        boolean canContinue = this.ensureModification(context);
        if (!canContinue) {
            return;
        }
        StorageService<?> storage = ObserveMainUIHandler.getStorage();
        try {
            log.debug((Object)(">>> close main storage " + storage));
            storage.doClose(false);
            ObserveMainUI ui = this.getUI(context);
            ui.getTreeHelper().setSelectedNode((JAXXContext)ui, null);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public void launchReloadStorage(JAXXContext context) {
        boolean canContinue = this.ensureModification(context);
        if (!canContinue) {
            return;
        }
        StorageService storage = ObserveMainUIHandler.getStorage();
        if (storage == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No storage to reload");
            }
            return;
        }
        StorageConfig config = storage.getConfig().clone();
        try {
            log.debug((Object)(">>> close main storage " + storage));
            storage.doClose(false);
        }
        catch (StorageServiceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        ObserveConfig appConfig = ObserveContext.getConfig();
        if (config instanceof H2StorageConfig) {
            H2StorageConfig h2Config = (H2StorageConfig)config;
            h2Config.setReferentielEditable(Boolean.valueOf(appConfig.isH2ReferentielEditable()));
            h2Config.setCanMigrate(appConfig.isCanMigrateH2());
            h2Config.detectPolicy();
        }
        if (config instanceof PGStorageConfig) {
            PGStorageConfig pgConfig = (PGStorageConfig)config;
            pgConfig.setCanMigrate(appConfig.isCanMigrateObstuna());
        }
        try {
            storage = StorageServiceFactory.newService((StorageConfig)config, storage.getClass());
            ObserveContext.get().prepareMainStorage(storage);
            storage.doOpen();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void launchSynchronizeReferentiel(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.synchronizeReferentiel"), I18n._((String)"observe.title.synchronizeReferentiel.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.SYNCHRONIZE_REFERENTIEL);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchExportData(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.exportData"), I18n._((String)"observe.title.exportData.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.EXPORT_DATA);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchValidateData(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.validateData"), I18n._((String)"observe.title.validateData.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.VALIDATE_DATA);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchImportGPS(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.importGPS"), I18n._((String)"observe.title.importGPS.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.IMPORT_GPS);
                ui.blockOperations();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ObserveMainUI ui) {
        log.info((Object)"ObServe quitting...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            if (!ObserveMain.isReload()) {
                System.exit(0);
            }
        }
    }

    public void changeScreen(ObserveMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setFullScreen(fullscreen);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showConfig(JAXXContext context) {
        ObserveMainUI ui = this.getUI(context);
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        ConfigUIModelBuilder builder = new ConfigUIModelBuilder();
        builder.createModel((ApplicationConfig)config);
        builder.registerCallBack("application", I18n.n_((String)"observe.action.reload.application"), (Icon)UIHelper.createActionIcon((String)"reload-application"), this.reloadApplicationCallback);
        builder.registerCallBack("ui", I18n.n_((String)"observe.action.reload.ui"), (Icon)UIHelper.createActionIcon((String)"reload-ui"), this.reloadUICallback);
        builder.registerCallBack("db", I18n.n_((String)"observe.action.reload.storage"), (Icon)UIHelper.createActionIcon((String)"reload-db"), this.reloadDBCallback);
        builder.addCategory(I18n.n_((String)"observe.config.category.directories"), I18n.n_((String)"observe.config.category.directories.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.CONFIG_FILE);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DB_DIRECTORY);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.TMP_DIRECTORY);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.RESOURCES_DIRECTORY);
        builder.setOptionCallBack("application");
        builder.addCategory(I18n.n_((String)"observe.config.category.h2"), I18n.n_((String)"observe.config.category.h2.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.H2_LOGIN);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.H2_PASSWORD);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.H2_CAN_MIGRATE);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.H2_REFERENTIEL_EDITABLE);
        builder.setOptionCallBack("db");
        builder.addCategory(I18n.n_((String)"observe.config.category.obstuna"), I18n.n_((String)"observe.config.category.obstuna.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSTUNA_URL);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSTUNA_LOGIN);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSTUNA_USE_SSL_CERT);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSTUNA_CAN_MIGRATE);
        builder.addCategory(I18n.n_((String)"observe.config.category.changeStorage"), I18n.n_((String)"observe.config.category.changeStorage.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DEFAULT_DB_MODE, "defaultDbMode");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DEFAULT_CREATION_MODE, "defaultCreationMode");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.CAN_GENERATE_EMPTY_DB, "canGenerateEmptyDb");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.STORE_REMOTE_STORAGE, "storeRemoteStorage");
        builder.addCategory(I18n.n_((String)"observe.config.category.gps"), I18n.n_((String)"observe.config.category.gps.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DEFAULT_GPS_MAX_DELAY, "defaultGpsMaxDelay");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DEFAULT_GPS_MAX_SPEED, "defaultGpsMaxSpeed");
        builder.addCategory(I18n.n_((String)"observe.config.category.synchro"), I18n.n_((String)"observe.config.category.synchro.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.CHANGE_SYNCHRO_SRC, "changeSynchroSrc");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DISPLAY_SYNCHRO_RESUME, "displaySynchroResume");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.H2_CAN_MIGRATE);
        builder.addCategory(I18n.n_((String)"observe.config.category.observation"), I18n.n_((String)"observe.config.category.observation.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_ACTIVITES_DETAILLEES, "observationActivitesDetaillees");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_FAUNE_ASSOCIEE, "observationFauneAssociee");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_GLEURE, "observationGleure");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_MAMMIFERES, "observationMammiferes");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_MENSURATIONS, "observationMensurations");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_OBJET_FLOTTANT, "observationObjetFlottant");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_OISEAUX, "observationOiseaux");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.OBSERVATION_REJETS_THONS, "observationRejetsThons");
        builder.addCategory(I18n.n_((String)"observe.config.category.other"), I18n.n_((String)"observe.config.category.other.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON, "showNumberEditorButton");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR, "autoPopupNumberEditor");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.FULL_SCREEN, "fullScreen");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.LOCALE, "locale");
        builder.setOptionCallBack("ui");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfigOption.DB_LOCALE, "dbLocale");
        builder.setOptionCallBack("ui");
        ConfigUIModel model = builder.flushModel();
        ConfigUI configUI = ConfigUIBuilder.newConfigUI((JAXXContext)context, (ConfigUIModel)model, (String)"observe.config.category.directories");
        ConfigUIBuilder.showConfigUI((ConfigUI)configUI, (Frame)ui, (boolean)false);
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        ObserveMainUI mainUI = this.getUI(context);
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        log.debug((Object)("show help " + helpId));
        mainUI.getHelp().setCurrentID(helpId);
        mainUI.setContextValue(mainUI.getMode(), "oldMode");
        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
        ObserveMainUI mainUI = this.getUI(context);
        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
        if (oldMode == null) {
            ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
            StorageService mainStorage = dataContext.getStorage();
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        mainUI.setMode(oldMode);
    }

    public void gotoSite(JAXXContext rootContext) {
        ObserveConfig config = ObserveContext.getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(I18n._((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(ObserveMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        about.setTitle(I18n._((String)"observe.title.about"));
        about.setAboutText(I18n._((String)"observe.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/observe-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/observe-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected static StorageService<?> getStorage() {
        ObserveDataContext dataContext = ObserveContext.getDataContext();
        StorageService storage = dataContext.getStorage();
        return storage;
    }

    public static void restartEdit(StorageUI ui) {
        ObserveContent selectedUI = (ObserveContent)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
        if (selectedUI != null && selectedUI.isEnabled()) {
            selectedUI.restartEdit();
        }
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        ObserveDataContext dataContext = ObserveContext.getDataContext();
        dataContext.removeJaxxPropertyChangeListener();
        config.removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        StorageService mainStorage = dataContext.getStorage();
        NavigationTreeNode node = null;
        ObserveUIMode oldMode = null;
        if (ui != null) {
            oldMode = ui.getMode();
            node = ui.getTreeHelper().getSelectedNode((JAXXContext)ui);
            ErrorDialogUI.init(null);
            ObserveContext.removeObserveMainUI();
            ui.dispose();
            ui.setVisible(false);
            if (mainStorage != null) {
                mainStorage.removeCachePropertyChangeListeners();
            }
        }
        ui = this.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        if (node != null) {
            ui.getTreeHelper().selectNode((JAXXContext)ui, node.getFullPath());
        }
        ui.getNavigation().requestFocus();
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        JPanel container;
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        ObserveMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        Boolean wasClosed = null;
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ObserveContent) {
            wasClosed = ObserveContentHandler.checkEdit((ObserveContentUI)((Object)currentContent));
        }
        return wasClosed == null || wasClosed != false;
    }

    ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = ObserveContext.getObserveMainUI();
        return ui;
    }

    class StorageBackupWizardLauncher
    extends StorageWizardLauncher {
        public StorageBackupWizardLauncher(JAXXContext context, Window frame, String title) {
            super(context, frame, title);
        }

        @Override
        protected void init(StorageUI ui) {
            ui.getBACKUP().getDoBackup().setSelected(true);
            ui.getBACKUP().getDoBackup().setVisible(false);
            ui.getModel().setSteps(new StorageStep[]{StorageStep.BACKUP, StorageStep.SELECT_DATA, StorageStep.CONFIRM});
            try {
                StorageService<?> service = ObserveMainUIHandler.getStorage();
                SelectDataModel dataModel = SelectDataModel.newModel(service);
                dataModel.setUseReferentiel(true);
                dataModel.addAllSelectedData();
                ui.getModel().setSelectDataModel(dataModel);
                ui.getSELECT_DATA().init();
            }
            catch (StorageServiceException e) {
                log.error((Object)e);
            }
        }

        protected void doAction(StorageUI ui) {
            log.info((Object)ui.getName());
            StorageUIHandler handler = this.getStorageUIHandler();
            StorageService<?> service = ObserveMainUIHandler.getStorage();
            StorageUIModel storageModel = ui.getModel();
            File backupFile = storageModel.getBackupFile();
            SelectDataModel dataModel = storageModel.getSelectDataModel();
            Set marees = null;
            if (dataModel != null && !dataModel.isFull()) {
                marees = dataModel.getSelectedData();
            }
            handler.backupLocalDatabase(service, backupFile, marees);
        }
    }
}

