/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.synchro;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.storage.CommonStorageConfigParam;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceAdapter;
import fr.ird.observe.storage.StorageServiceEvent;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.StorageServiceListener;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageConfigParam;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.synchro.SynchroStep;
import fr.ird.observe.ui.synchro.SynchroUIModel;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationAction;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class SynchroOperationAction
extends WizardOperationAction<SynchroStep, SynchroUIModel> {
    private static final Log log = LogFactory.getLog(SynchroOperationAction.class);
    JAXXContext context;
    protected final StorageServiceListener serviceLogger = new StorageServiceAdapter(){

        public void onNewMessage(StorageServiceEvent event) {
            StorageService service = event.getSource();
            if (event.getMessageLevel() == StorageServiceEvent.MessageLevel.INFO) {
                SynchroOperationAction.this.sendMessage(service.getShortLabel() + " : " + event.getMessage());
            }
        }
    };

    public SynchroOperationAction(SynchroStep operation) {
        super((WizardOperationStep)operation);
    }

    public void start(JAXXContext context) {
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.start", (Object[])new Object[]{new Date()}));
        this.context = context;
        super.execute();
    }

    protected SynchroUIModel getModel() {
        SynchroUIModel model = (SynchroUIModel)((Object)this.context.getContextValue(SynchroUIModel.class));
        return model;
    }

    protected JAXXContext getContext() {
        return this.context;
    }

    public WizardOperationState onCancel(SynchroUIModel model, Exception e) {
        log.trace((Object)this);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.canceled"));
        return WizardOperationState.CANCELED;
    }

    public WizardOperationState onError(SynchroUIModel model, Exception e) {
        this.setError(e);
        log.error((Object)e.getMessage(), (Throwable)e);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.failed"));
        return WizardOperationState.FAILED;
    }

    public void copyTo(SynchroOperationAction newAction) {
    }

    protected StorageService<?> createLocalService(StorageUIModel model, StorageService<?> previousService) throws Exception {
        if (model.isLocalStorageExist() && model.getDbMode() == DbMode.LOCAL && model.getCreationMode() != CreationMode.USE_LOCAL_STORAGE) {
            this.sendMessage(I18n._((String)"observe.message.synchro.destroy.local.db"));
            log.debug((Object)("destroy previous local database (try to use " + previousService + ")"));
            StorageService<?> localService = null;
            if (previousService != null && previousService instanceof H2StorageService && previousService.isOpen()) {
                localService = previousService;
            } else {
                localService = ObserveContext.get().newLocalStorageService();
                localService.addStorageServiceListener(this.serviceLogger);
                localService.doOpen();
            }
            localService.doClose(true);
            localService.removeStorageServiceListener(this.serviceLogger);
            ((ObserveConfig)((Object)ObserveContext.get().getContextValue(ObserveConfig.class))).setLocalStorageExist(false);
        }
        StorageService<?> service = null;
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        if (previousService != null && previousService instanceof H2StorageService && model.getDbMode() == DbMode.LOCAL && previousService.isOpen()) {
            previousService.doClose(false);
            previousService.removeStorageServiceListener(this.serviceLogger);
        }
        service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected StorageService<?> createReferentielService(StorageUIModel model) throws IOException {
        StorageService<?> service = null;
        StorageUIHandler handler = (StorageUIHandler)this.getContext().getContextValue(StorageUIHandler.class);
        service = handler.newServiceFromModel(this.context, model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected StorageService<?> createSynchroService() throws IOException {
        ObserveConfig mainConfig = (ObserveConfig)((Object)this.context.getContextValue(ObserveConfig.class));
        H2StorageConfig conf = StorageServiceFactory.newH2Config((String)I18n.n_((String)"observe.storage.label.synchro"), (Object[])new Object[]{CommonStorageConfigParam.LOGIN, "sa", CommonStorageConfigParam.PASSWORD, "sa".toCharArray(), H2StorageConfigParam.CREATION_MODE, CreationMode.EMPTY, H2StorageConfigParam.DIRECTORY, new File(mainConfig.getTmpDirectory(), "synchrodb_" + System.nanoTime())});
        H2StorageService service = StorageServiceFactory.newService((H2StorageConfig)conf);
        ObserveContext.get().prepareMainStorage((StorageService<?>)service);
        ((H2StorageConfig)service.getConfig()).setUseCache(false);
        service.addStorageServiceListener(this.serviceLogger);
        return service;
    }

    protected void openService(StorageService<?> service) throws StorageServiceException {
        if (!service.isOpen()) {
            service.doOpen();
        }
    }
}

