/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.storage.DbMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.AbstractStorageTabPanelUI;
import fr.ird.observe.ui.storage.tabs.BackupPanelUI;
import fr.ird.observe.ui.storage.tabs.ChooseCreationModePanelUI;
import fr.ird.observe.ui.storage.tabs.ChooseDbModePanelUI;
import fr.ird.observe.ui.storage.tabs.ConfigStoragePanelUI;
import fr.ird.observe.ui.storage.tabs.ConfirmPanelUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class StorageUI
extends JDialog
implements WizardUI<StorageStep, StorageUIModel>,
JAXXObject {
    public static final String BINDING_APPLY_ACTION_ENABLED = "applyAction.enabled";
    public static final String BINDING_APPLY_ACTION_VISIBLE = "applyAction.visible";
    public static final String BINDING_NEXT_ACTION_ENABLED = "nextAction.enabled";
    public static final String BINDING_NEXT_ACTION_VISIBLE = "nextAction.visible";
    public static final String BINDING_PREVIOUS_ACTION_ENABLED = "previousAction.enabled";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuLGD4wRKQ0uBgJxQRQlqN6hIFVIoNHYS6uLEUZygihzCeHdiTxnvDDOziU0UxI0rfwLcuSBx44Q4cObABfEvoIoDV8Sb2V3/XGMLkcSOPe+97733zXuf/e0fKK0kWnqCWy1HBr6mTeI82nz8uFJ7Qly9RZQrqdBcovBnKoVSxyjndc6VRq8fl034ehS+XuRNwX3i90RvlNGs0m1GVIMQrdGr/RGuUuvVjnmjJQIZo3aKSkL9+s+nqa+8L75JIdQSUN08tJIfF9XtZLqMUtTT6BpkOsPrDPt1KENSvw71zpuzIsNK7eEm+RR9jmbKKCOwBDCNlidv2WLY+JbQKKfAhutkF1MfqDuVDpWew2uKyDPiBNSJ7E41/H9UEsJGZzSau1XE0ivjNg/0mxotmAodfK6d7nHX+dniw0qlun2yVTjZrWxta3R3dC6Na8opNjhXZKu2yz2yj33CjkoGKttBfCFCLB5sbx6WKnsR7tsT4RYlwZpyfyR6pljZ2ym9r9Fb4/C4f0rrET3JUIXN4gdH+xrdHgNVwO4ngUjEmLHlHOxqdGeSemQzEWXaeGj0ormplqPOYbScR4e4ViOe8R9IeQssjMDN3uyb4TDM2voD5lzsu4RtuobYaB46WQqB1tw3nkvdmRCSnFEeqDDEnK70e8z6pKVHWnNYCNYeNkv0Sl/FsM9Od5+7Czd1jNIygGNo8XhYAg7AFC7/zYHlN4DW+veNhV9/+P37nXjjs5D7eqJrj2DBJgrJBZGamtTPheseaMrWd7HYOAYUwkDtrJotJhRWjcxQHOR73u6dCXceYtUAiPTMbz/+dOPjX66g1A6aZRx7O9j4l1BWNySwwJnXEu89sBXNnT8Dz1fhkdbwRzUDihbj6bLvHbcBWkTiOdPoukdOccB0kcEqVaATHF75VY8qAUcn3D9xjQ2Gn1khgHW98Ml5vsClR2QoDqtrlxploR76mRkmyH6KmYlJN7mHmRlXGZAW8L+YwH+HhFr2578Wqt89iO9gCjh5aaR79x7SH6EM9Rn1idXdSFITdTYnFAk83pXOJDFF/WoqIu27a5/vDbE9BdzULBsavXER8hJeU9txjTqR7abQ7dCweu+2/V27bAUGrmD7NK+2ULTW4/JdMX6wTXB78eViuzlOuLawbOH7kmuuMhOf5jTn7JCKQxu7NBAbS0/oDeMikgrsU4ZxhU6D9BDfTAR8Fq5cwLwZkWaraw683I8Uo6qJWF3LL93P+wFjl53elgfqq3PNnVhmoFo7vn2NzsfWOwowB/tdGY83qukBdRvXdrq37Zd726bqQ8yoF7bcbfW1pNKMXsZtzpxRRe1iLQ+wuAdeQwz2sZI1QImMJDLcTTuKjR4l/9+ZWBwxlPbjYUIe7ifzkMGuCxwMkpD/t4yjKOj9uJpAHUaJ7LV3QtXKYw1fDmuBJu8OZZsyz7OTSFCD0HpDG/uX/x0lfQ7fWxtjQP4BFNWOytwLAAA=";
    protected static final Log log = LogFactory.getLog(StorageUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected BackupPanelUI BACKUP;
    protected ChooseCreationModePanelUI CHOOSE_CREATION_MODE;
    protected ChooseDbModePanelUI CHOOSE_DB_MODE;
    protected ConfigStoragePanelUI CONFIG;
    protected ConfirmPanelUI CONFIRM;
    protected JButton applyAction;
    protected JButton cancelAction;
    protected JButton nextAction;
    protected JButton previousAction;
    protected StorageUI storageMain = this;
    protected JTabbedPane tabs;
    private CardLayout $CardLayout0;
    private Table $Table0;
    private boolean contextInitialized;

    public StorageUI(Window owner, JAXXContext parentContext) {
        super(owner);
        this.$initialize();
        Util.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)Util.newContextEntryDef(StorageUIModel.class));
        Util.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)Util.newContextEntryDef((String)"apply", Runnable.class));
        Util.checkJAXXContextEntry((JAXXContext)parentContext, (JAXXContextEntryDef)Util.newContextEntryDef((String)"cancel", Runnable.class));
        if (owner != null) {
            this.setContextValue(owner, "parent");
        }
        Util.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.contextInitialized = true;
        Util.assignment((boolean)true, (String)"contextInitialized", (JAXXObject)this);
        this.$initialize();
    }

    public StorageUIModel getModel() {
        return this.getContextValue(StorageUIModel.class);
    }

    public void start() {
        this.getModel().start();
        UIHelper.center((Component)this.getContextValue(Window.class, "parent"), (Component)this);
        this.setVisible(true);
    }

    public StorageStep getSelectedStep() {
        int index = this.tabs.getSelectedIndex();
        AbstractStorageTabPanelUI c = null;
        if (index > -1) {
            c = (AbstractStorageTabPanelUI)this.tabs.getComponentAt(index);
        }
        StorageStep result = c == null ? null : c.getStep();
        return result;
    }

    public AbstractStorageTabPanelUI getStepUI(StorageStep step) {
        if (step != null) {
            return (AbstractStorageTabPanelUI)this.getObjectById(step.name());
        }
        return null;
    }

    public AbstractStorageTabPanelUI getStepUI(int stepIndex) {
        if (stepIndex > this.tabs.getTabCount()) {
            return null;
        }
        return (AbstractStorageTabPanelUI)this.tabs.getComponentAt(stepIndex);
    }

    public AbstractStorageTabPanelUI getSelectedStepUI() {
        StorageStep step = this.getSelectedStep();
        AbstractStorageTabPanelUI ui = this.getStepUI(step);
        return ui;
    }

    public void onWasStarted() {
        this.getTabs().setTitleAt(0, I18n._((String)"observe.synchro.step.progression"));
    }

    public void onModelStateChanged(WizardOperationState newState) {
    }

    public void onOperationStateChanged(StorageStep step, WizardOperationState newState) {
    }

    public void onStepChanged(StorageStep newStep) {
    }

    public void onStepsChanged(StorageStep[] steps) {
    }

    public StorageUIHandler getHandler() {
        return this.getContextValue(StorageUIHandler.class);
    }

    public void apply() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StorageUIModel model = StorageUI.this.getModel();
                    if (model.isStoreRemoteConfig() && model.getDbMode() == DbMode.REMOTE) {
                        log.debug((Object)("store remote config from " + (Object)((Object)model)));
                        StorageUI.this.getHandler().storeRemoteConfig((JAXXContext)StorageUI.this, model);
                    }
                    Runnable action = StorageUI.this.getContextValue(Runnable.class, "apply");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    StorageUI.this.dispose();
                }
            }
        });
    }

    public void cancel() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Runnable action = StorageUI.this.getContextValue(Runnable.class, "cancel");
                    action.run();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    StorageUI.this.dispose();
                }
            }
        });
    }

    void $afterCompleteSetup() {
        this.getModel().addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                StorageStep oldStep = (StorageStep)((Object)evt.getOldValue());
                StorageStep newStep = (StorageStep)((Object)evt.getNewValue());
                log.debug((Object)("step has changed <old:" + (Object)((Object)oldStep) + ", new:" + (Object)((Object)newStep) + ">"));
                int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
                int newStepIndex = model.getStepIndex(newStep);
                if (oldStepIndex + 1 == newStepIndex) {
                    AbstractStorageTabPanelUI c = (AbstractStorageTabPanelUI)StorageUI.this.getObjectById(newStep.name());
                    String title = I18n._((String)newStep.getLabel());
                    String tip = I18n._((String)newStep.getDescription());
                    StorageUI.this.tabs.addTab(title, null, c, tip);
                    int index = StorageUI.this.tabs.indexOfComponent(c);
                    if (index > -1) {
                        StorageUI.this.tabs.setSelectedIndex(index);
                    }
                } else if (oldStepIndex > newStepIndex) {
                    int index = newStepIndex + 1;
                    while (StorageUI.this.tabs.getTabCount() > index) {
                        log.trace((Object)("remove tab : " + index));
                        StorageUI.this.tabs.remove(index);
                    }
                } else {
                    throw new IllegalStateException("can not go from " + (Object)((Object)oldStep) + " to " + (Object)((Object)newStep));
                }
            }
        });
        this.getModel().init((JAXXContext)this);
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public StorageUI() {
        this.$initialize();
    }

    public StorageUI(JAXXContext parentContext) {
        Util.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__applyAction(ActionEvent event) {
        this.apply();
    }

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        this.cancel();
    }

    public void doActionPerformed__on__nextAction(ActionEvent event) {
        this.getModel().gotoNextStep();
    }

    public void doActionPerformed__on__previousAction(ActionEvent event) {
        this.getModel().gotoPreviousStep();
    }

    public void doStateChanged__on__tabs(ChangeEvent event) {
        this.getModel().gotoStep(this.getSelectedStep());
    }

    public JButton getApplyAction() {
        return this.applyAction;
    }

    public BackupPanelUI getBACKUP() {
        return this.BACKUP;
    }

    public ChooseCreationModePanelUI getCHOOSE_CREATION_MODE() {
        return this.CHOOSE_CREATION_MODE;
    }

    public ChooseDbModePanelUI getCHOOSE_DB_MODE() {
        return this.CHOOSE_DB_MODE;
    }

    public ConfigStoragePanelUI getCONFIG() {
        return this.CONFIG;
    }

    public ConfirmPanelUI getCONFIRM() {
        return this.CONFIRM;
    }

    public JButton getCancelAction() {
        return this.cancelAction;
    }

    public JButton getNextAction() {
        return this.nextAction;
    }

    public JButton getPreviousAction() {
        return this.previousAction;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    protected CardLayout get$CardLayout0() {
        return this.$CardLayout0;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected void addChildrenToStorageMain() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add(this.CHOOSE_DB_MODE);
        this.add(this.CHOOSE_CREATION_MODE);
        this.add(this.CONFIG);
        this.add(this.BACKUP);
        this.add(this.CONFIRM);
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.$Table0, "South");
    }

    protected void createApplyAction() {
        this.applyAction = new JButton();
        this.$objectMap.put("applyAction", this.applyAction);
        this.applyAction.setName("applyAction");
        this.applyAction.setText(I18n._((String)"observe.action.storage.apply"));
        this.applyAction.setToolTipText(I18n._((String)"observe.action.storage.apply.tip"));
        this.applyAction.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__applyAction"));
    }

    protected void createBACKUP() {
        this.BACKUP = new BackupPanelUI((JAXXContext)this);
        this.$objectMap.put("BACKUP", this.BACKUP);
        this.BACKUP.setName("BACKUP");
    }

    protected void createCHOOSE_CREATION_MODE() {
        this.CHOOSE_CREATION_MODE = new ChooseCreationModePanelUI((JAXXContext)this);
        this.$objectMap.put("CHOOSE_CREATION_MODE", this.CHOOSE_CREATION_MODE);
        this.CHOOSE_CREATION_MODE.setName("CHOOSE_CREATION_MODE");
    }

    protected void createCHOOSE_DB_MODE() {
        this.CHOOSE_DB_MODE = new ChooseDbModePanelUI((JAXXContext)this);
        this.$objectMap.put("CHOOSE_DB_MODE", this.CHOOSE_DB_MODE);
        this.CHOOSE_DB_MODE.setName("CHOOSE_DB_MODE");
    }

    protected void createCONFIG() {
        this.CONFIG = new ConfigStoragePanelUI((JAXXContext)this);
        this.$objectMap.put("CONFIG", this.CONFIG);
        this.CONFIG.setName("CONFIG");
    }

    protected void createCONFIRM() {
        this.CONFIRM = new ConfirmPanelUI((JAXXContext)this);
        this.$objectMap.put("CONFIRM", this.CONFIRM);
        this.CONFIRM.setName("CONFIRM");
    }

    protected void createCancelAction() {
        this.cancelAction = new JButton();
        this.$objectMap.put("cancelAction", this.cancelAction);
        this.cancelAction.setName("cancelAction");
        this.cancelAction.setText(I18n._((String)"observe.action.cancel"));
        this.cancelAction.setToolTipText(I18n._((String)"observe.action.storage.cancel.tip"));
        this.cancelAction.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancelAction"));
    }

    protected void createNextAction() {
        this.nextAction = new JButton();
        this.$objectMap.put("nextAction", this.nextAction);
        this.nextAction.setName("nextAction");
        this.nextAction.setText(I18n._((String)"observe.action.goto.next.stage"));
        this.nextAction.setToolTipText(I18n._((String)"observe.action.goto.next.stage.tip"));
        this.nextAction.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__nextAction"));
    }

    protected void createPreviousAction() {
        this.previousAction = new JButton();
        this.$objectMap.put("previousAction", this.previousAction);
        this.previousAction.setName("previousAction");
        this.previousAction.setText(I18n._((String)"observe.action.goto.previous.stage"));
        this.previousAction.setToolTipText(I18n._((String)"observe.action.goto.previous.stage.tip"));
        this.previousAction.addActionListener((ActionListener)Util.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__previousAction"));
    }

    protected void createTabs() {
        this.tabs = new JTabbedPane();
        this.$objectMap.put("tabs", this.tabs);
        this.tabs.setName("tabs");
        this.tabs.addChangeListener((ChangeListener)Util.getEventListener(ChangeListener.class, (String)"stateChanged", (Object)this, (String)"doStateChanged__on__tabs"));
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.addChildrenToStorageMain();
        this.$Table0.add((Component)this.cancelAction, (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.previousAction, (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.nextAction, (Object)new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.applyAction, (Object)new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        Util.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.tabs.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.cancelAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"cancel"));
        this.previousAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"previous-step"));
        this.nextAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"next-step"));
        this.applyAction.setIcon(SwingUtil.getUIManagerActionIcon((String)"accept"));
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$registerDefaultBindings();
        this.$objectMap.put("storageMain", this);
        this.$CardLayout0 = new CardLayout();
        this.$objectMap.put("$CardLayout0", this.$CardLayout0);
        this.createCHOOSE_DB_MODE();
        this.createCHOOSE_CREATION_MODE();
        this.createCONFIG();
        this.createBACKUP();
        this.createCONFIRM();
        this.createTabs();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.createCancelAction();
        this.createPreviousAction();
        this.createNextAction();
        this.createApplyAction();
        this.setName("storageMain");
        this.setDefaultCloseOperation(2);
        SwingUtil.setComponentHeight((Component)this.storageMain, (int)560);
        SwingUtil.setComponentWidth((Component)this.storageMain, (int)550);
        this.setTitle(I18n._((String)"observe.title.change.storage"));
        this.storageMain.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.setModal(true);
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_PREVIOUS_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.previousAction.setEnabled(StorageUI.this.getModel().getPreviousStep() != null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("previousStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.nextAction.setEnabled(StorageUI.this.getModel().isValidStep());
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NEXT_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.nextAction.setVisible(StorageUI.this.getModel().getNextStep() != null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_APPLY_ACTION_ENABLED, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.applyAction.setEnabled(StorageUI.this.getModel().isValidStep());
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("validStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_APPLY_ACTION_VISIBLE, true){

            public void applyDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().addPropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.applyAction.setVisible(StorageUI.this.getModel().getNextStep() == null);
                }
            }

            public void removeDataBinding() {
                if (StorageUI.this.getModel() != null) {
                    StorageUI.this.getModel().removePropertyChangeListener("nextStep", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

