/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.RoutesUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityLoador;

public class RoutesHandler
extends ObserveContentHandler<Void, Maree, RoutesUI>
implements JAXXAction {
    private static Log log = LogFactory.getLog(RoutesHandler.class);

    public RoutesHandler() {
        super(null, null, null, new EntityLoador<Maree>(Maree.class, null, new String[]{"open", "route"}){
            private static final long serialVersionUID = 1L;

            public void load(Maree from, Maree dst, boolean tech) {
                super.load((TopiaEntity)from, (TopiaEntity)dst, tech);
                List routes = dst.getRoute();
                if (routes != null) {
                    dst.setRoute(new ArrayList(routes));
                }
            }
        });
    }

    public void addRoute(RoutesUI context) {
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = this.getTreeBuilder((JAXXContext)context).addRoute(parentNode, null);
        this.repaintNode((JAXXContext)context, parentNode, true);
        this.selectNode((JAXXContext)context, node);
    }

    public void gotoRoute(RoutesUI context, Route selectedRoute) {
        if (selectedRoute == null) {
            return;
        }
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedRoute.getTopiaId());
        this.selectNode((JAXXContext)context, node);
    }

    @Override
    public void openUI(RoutesUI context) throws Exception {
        super.openUI(context);
        Maree maree = this.getData((JAXXContext)context, Maree.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        this.loador.load((Object)maree, (Object)context.getEditBean(), true);
        context.setMode(mode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(RoutesUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Maree maree = this.getData((JAXXContext)context, Maree.class);
            Route openRoute = this.getDataContext((JAXXContext)context).getOpenRoute();
            if (openRoute == null) {
                if (maree.isOpen()) {
                    mode = ObserveContentMode.CREATE;
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.no.active.route.found"));
                } else {
                    mode = ObserveContentMode.READ;
                }
            } else if (maree.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.active.route.found"));
            } else {
                mode = ObserveContentMode.READ;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.active.route.found.for.other.maree"));
            }
            if (!maree.isOpen()) {
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
            }
        }
        return mode;
    }
}

