/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.controller.v1;

import com.google.common.base.Preconditions;
import fr.ird.observe.application.web.controller.ObserveWebMotionController;
import fr.ird.observe.application.web.request.ObserveWebRequestContext;
import fr.ird.observe.application.web.security.ObserveWebSecurityApplicationContext;
import fr.ird.observe.services.ObserveService;
import fr.ird.observe.services.configuration.ObserveDataSourceConfiguration;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import fr.ird.observe.services.spi.NoDataAccess;
import java.lang.reflect.Method;

public abstract class ObserveServiceControllerSupport<S extends ObserveService>
extends ObserveWebMotionController
implements ObserveService {
    protected final Class<S> serviceType;

    protected ObserveServiceControllerSupport(Class<S> serviceType) {
        this.serviceType = serviceType;
    }

    protected S getAuthenticatedService() {
        Method method = this.contextable.getCall().getCurrent().getMethod();
        Method serviceTypeMethod = this.getServiceMethod(method);
        boolean requiredAuthentication = serviceTypeMethod.getAnnotation(NoDataAccess.class) == null;
        Preconditions.checkState((boolean)requiredAuthentication, (Object)("Vous avez demand\u00e9 un service authentifi\u00e9, alors que l'annotation " + NoDataAccess.class.getName() + " est pr\u00e9sente sur la m\u00e9thode du service"));
        ObserveWebRequestContext requestContext = this.getRequestContext();
        String authenticationToken = requestContext.getAuthenticationToken();
        ObserveWebSecurityApplicationContext securityApplicationContext = this.getSecurityApplicationContext();
        ObserveDataSourceConfigurationAndConnection configurationAndConnection = securityApplicationContext.getDataSourceConfigurationAndConnection(authenticationToken);
        return (S)requestContext.newService(this.serviceType, configurationAndConnection);
    }

    protected S getAnonymousService(ObserveDataSourceConfiguration dataSourceConfiguration) {
        Method method = this.contextable.getCall().getCurrent().getMethod();
        Method serviceTypeMethod = this.getServiceMethod(method);
        boolean requiredAuthentication = serviceTypeMethod.getAnnotation(NoDataAccess.class) == null;
        Preconditions.checkState((!requiredAuthentication ? 1 : 0) != 0, (Object)("Vous avez demand\u00e9 un service anonyme, alors que l'annotation " + NoDataAccess.class.getName() + " n'est pas pr\u00e9sente sur la m\u00e9thode du service"));
        ObserveWebRequestContext requestContext = this.getRequestContext();
        return (S)requestContext.newService(this.serviceType, dataSourceConfiguration);
    }

    protected Method getServiceMethod(Method method) {
        try {
            return this.serviceType.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Can't happen!");
        }
    }
}

