/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public interface Unit extends BusinessEntity {

    String EXT_UNIT = "Unit";

    String FIELD_UNIT_NAME = "name";

    String FQ_FIELD_UNIT_NAME = EXT_UNIT + ".name";

    ElementField ELEMENT_FIELD_UNIT_NAME = new ElementField(FQ_FIELD_UNIT_NAME);

    String FIELD_UNIT_ADDRESS = "address";

    String FQ_FIELD_UNIT_ADDRESS = EXT_UNIT + ".address";

    ElementField ELEMENT_FIELD_UNIT_ADDRESS = new ElementField(FQ_FIELD_UNIT_ADDRESS);

    String FIELD_UNIT_FULLNAME = "fullName";

    String FQ_FIELD_UNIT_FULLNAME = EXT_UNIT + ".fullName";

    ElementField ELEMENT_FIELD_UNIT_FULLNAME = new ElementField(FQ_FIELD_UNIT_FULLNAME);

    String FIELD_UNIT_UNITDEPTLINK = "unitDeptLink";

    String FQ_FIELD_UNIT_UNITDEPTLINK = EXT_UNIT + ".unitDeptLink";

    ElementField ELEMENT_FIELD_UNIT_UNITDEPTLINK = new ElementField(FQ_FIELD_UNIT_UNITDEPTLINK);

    String getName();

    void setName(String name);

    String getAddress();

    void setAddress(String address);

    String getFullName();

    void setFullName(String fullName);

    Set<String> getUnitDeptLink();

    void setUnitDeptLink(Set<String> unitDeptLink);

    void addAllUnitDeptLink(Collection<String> unitDeptLink);

    void addUnitDeptLink(String... element);

    void removeUnitDeptLink(String... element);

    void clearUnitDeptLink();

    Set<UnitDeptLink> getUnitDeptLink(boolean exceptionIfNotLoaded);

    void setUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink);

    void addAllUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink);

    void addUnitDeptLink(UnitDeptLink... element);

    void removeUnitDeptLink(UnitDeptLink... element);

} //Unit
