/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class UserAbstract extends BusinessEntityImpl implements User {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionUser;

    private static final long serialVersionUID = 4123101750330156601L;

    @Override
    public String getLastName() {
String value = UserHelper.getLastName(getWikitty());
return value;
}

    @Override
    public void setLastName(String lastName) {
String oldValue = getLastName();
UserHelper.setLastName(getWikitty(), lastName);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_LASTNAME, oldValue, getLastName());
}

    @Override
    public String getFirstName() {
String value = UserHelper.getFirstName(getWikitty());
return value;
}

    @Override
    public void setFirstName(String firstName) {
String oldValue = getFirstName();
UserHelper.setFirstName(getWikitty(), firstName);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_FIRSTNAME, oldValue, getFirstName());
}

    @Override
    public String getEmail() {
String value = UserHelper.getEmail(getWikitty());
return value;
}

    @Override
    public void setEmail(String email) {
String oldValue = getEmail();
UserHelper.setEmail(getWikitty(), email);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_EMAIL, oldValue, getEmail());
}

    @Override
    public String getComment() {
String value = UserHelper.getComment(getWikitty());
return value;
}

    @Override
    public void setComment(String comment) {
String oldValue = getComment();
UserHelper.setComment(getWikitty(), comment);
getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_COMMENT, oldValue, getComment());
}

    @Override
    public String getLogin() {
String value = WikittyUserHelper.getLogin(getWikitty());
return value;
}

    @Override
    public void setLogin(String login) {
String oldValue = getLogin();
WikittyUserHelper.setLogin(getWikitty(), login);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    @Override
    public String getPassword() {
String value = WikittyUserHelper.getPassword(getWikitty());
return value;
}

    @Override
    public void setPassword(String password) {
String oldValue = getPassword();
WikittyUserHelper.setPassword(getWikitty(), password);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    public UserAbstract() {
        super();
}

    public UserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public UserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionUser = new WikittyExtension(EXT_USER,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                WikittyUser.EXT_WIKITTYUSER,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String lastName unique=\"true\"", 
                                             "String firstName unique=\"true\"", 
                                             "String email unique=\"true\"", 
                                             "String comment unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionUser);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return UserHelper.toString(getWikitty());
}

} //UserAbstract
