/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;


public  class UnitDTO implements Unit {


@WikittyField(fqn="Unit.name")    protected String name;

@WikittyField(fqn="Unit.address")    protected String address;

@WikittyField(fqn="Unit.fullName")    protected String fullName;

@WikittyField(fqn="Unit.unitDeptLink")    protected Set<String> unitDeptLink = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        return name;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    /**
     * getAddress :
     * @return String 
     */

    @Override
    public String getAddress() {
        return address;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(String address) {
        this.address=address;
        modificationCount++;
}

    /**
     * getFullName :
     * @return String 
     */

    @Override
    public String getFullName() {
        return fullName;
}

    /**
     * setFullName :
     * @param fullName 
     */

    @Override
    public void setFullName(String fullName) {
        this.fullName=fullName;
        modificationCount++;
}

    /**
     * getUnitDeptLink :
     * @return Set<String> 
     */

    @Override
    public Set<String> getUnitDeptLink() {
        return unitDeptLink;
}

    /**
     * setUnitDeptLink :
     * @param unitDeptLink 
     */

    @Override
    public void setUnitDeptLink(Set<String> unitDeptLink) {
        if (unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.unitDeptLink=new LinkedHashSet<String>(unitDeptLink);
        }
        modificationCount++;
}

    /**
     * addAllUnitDeptLink :
     * @param unitDeptLink 
     */

    @Override
    public void addAllUnitDeptLink(Set<String> unitDeptLink) {
        if (this.unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        }
        this.unitDeptLink.addAll(unitDeptLink);
        modificationCount++;
}

    /**
     * addUnitDeptLink :
     * @param element 
     */

    @Override
    public void addUnitDeptLink(String element) {
        if (this.unitDeptLink == null){
            this.unitDeptLink = new LinkedHashSet<String>();
        }
        this.unitDeptLink.add(element);
        modificationCount++;
}

    /**
     * removeUnitDeptLink :
     * @param element 
     */

    @Override
    public void removeUnitDeptLink(String element) {
        unitDeptLink.remove(element);
        modificationCount++;
}

    /**
     * clearUnitDeptLink :
     */

    @Override
    public void clearUnitDeptLink() {
        unitDeptLink.clear();
        modificationCount++;
}

    /**
     * UnitDTO :
     */

    public UnitDTO() {
}

    /**
     * UnitDTO :
     * @param wikittyId 
     */

    public UnitDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof Unit)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        Unit sourceCopy = (Unit)source;

        setName(sourceCopy.getName());

        setAddress(sourceCopy.getAddress());

        setFullName(sourceCopy.getFullName());

        Set<String> unitDeptLink = sourceCopy.getUnitDeptLink();
        if (unitDeptLink != null){
            setUnitDeptLink(new LinkedHashSet<String>(unitDeptLink));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //UnitDTO
