/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterValues;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.WaoFilter;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.ui.components.FilterComponent;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.util.EnumSelectModel;

public class ContactFilterComponent
extends FilterComponent<ContactFilter> {
    @Inject
    private Messages messages;
    @Inject
    private ServiceContact serviceContact;
    @Parameter(required=false)
    private Boolean synthesisMode;
    @Persist
    private ContactFilterValues possibleValuesForFilter;

    public void resetFilter() {
        ContactFilter filter = this.serviceContact.newContactFilter(this.getUser());
        if (this.getSynthesisMode().booleanValue()) {
            filter.setEstimatedTides(true);
        } else {
            filter.setOrderBy("creationDate desc");
        }
        this.setFilter((WaoFilter)filter);
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }

    public ContactFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public ContactFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected ContactFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceContact.getPossibleValuesForFilter((ContactFilter)this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public SelectModel getContactStateSelectModel() {
        List allowedStates = ContactState.getAllowedStates((ObsProgram)this.getUser().getProfile().getObsProgram());
        return new EnumSelectModel(ContactState.class, this.messages, (Enum[])allowedStates.toArray(new ContactState[allowedStates.size()]));
    }

    public Boolean getFiltersVisible() {
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null && !(filtersVisible = this.getVisibleOnStartup()).booleanValue()) {
            filtersVisible = !((ContactFilter)this.getFilter()).isFiltered();
        }
        return filtersVisible;
    }

    public Boolean getSynthesisMode() {
        if (this.synthesisMode == null) {
            this.synthesisMode = Boolean.FALSE;
        }
        return this.synthesisMode;
    }

    public boolean showTerrestrialLocations() {
        boolean show = ((ContactFilter)this.getFilter()).getSamplingFilter().getObservationUnit() != null || ((ContactFilter)this.getFilter()).getSamplingFilter().getTerrestrialDistrict() != null;
        return show;
    }

    public String getFormatForPeriod() {
        return "dd/MM/yyyy";
    }
}

