/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.TapestryUtil;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Response;
import org.nuiton.util.DateUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/**
 * Page to acces to ical export for SamplingPlan. The activate method
 * will return the StreamResponse with ical data.
 *
 * @author sletellier
 */
public class RoadMap {

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceUser serviceUser;

    StreamResponse onActivate(Object... activationContext) throws IOException {

        // FIXME 20110601 the method is called when action link is created, leading to an exception raise, code may be moved to another method

        String tokenId = TapestryUtil.getFirstString(activationContext);

        ConnectedUser connectedUser = serviceUser.getConnectedUserByToken(tokenId);

        InputStream inputStream = serviceSampling.exportSamplingPlanICalendar(connectedUser);

        return new ICalStreamResponse(inputStream);
    }

    protected class ICalStreamResponse implements StreamResponse {
        protected InputStream inputStream;

        public ICalStreamResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public String getContentType() {
            return "text/calendar";
        }

        @Override
        public InputStream getStream() throws IOException {
            return inputStream;
        }

        @Override
        public void prepareResponse(Response response) {
            Date current = WaoUtils.getCurrentDate();
            response.setHeader("Content-Disposition",
                    "attachment; filename=\"observation_obsdeb_" + DateUtil.formatDate(current, "dd-MM-yyyy") + ".ics" +"\"");
        }
    }
}
