/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.ObservationType;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.components.SamplingFilterComponent;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.SampleRowDataSource;
import fr.ifremer.wao.ui.data.WaoActivationContext;
import fr.ifremer.wao.ui.services.SampleRowModelFactory;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;
import org.slf4j.Logger;

@RequiresAuthentication(allowedPrograms={ObsProgram.OBSDEB})
public class ObsDebSamplingPlan {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private Messages messages;
    @Inject
    private WaoManager manager;
    private DateFormat dateFormat;
    @SessionState
    @Property
    private ConnectedUser connectedUser;
    private WaoActivationContext waoActivationContext;
    @Persist
    private Boolean showImport;
    @InjectComponent
    private Zone importZone;
    @InjectComponent
    private SamplingFilterComponent samplingFilter;
    private SampleRowDataSource sampleRows;
    @Property
    private SampleRow sampleRow;
    private BeanModel<SampleRow> obsdebSamplingPlanModel;
    @Property
    private Boat substitute;

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/YYYY");
        }
        return this.dateFormat;
    }

    void onActivate(EventContext ec) {
        this.waoActivationContext = WaoActivationContext.newContextFromTapestry((EventContext)ec);
    }

    public ServiceSampling getServiceSampling() {
        return this.serviceSampling;
    }

    @Log
    public boolean getShowImport() {
        if (this.showImport == null) {
            this.showImport = false;
        }
        return this.showImport;
    }

    @Log
    public Object onActionFromShowFilters() {
        this.samplingFilter.switchFiltersVisible();
        return this.samplingFilter;
    }

    public Block onSuccessFromImportForm() {
        this.showImport = false;
        return this.importZone.getBody();
    }

    public ImportEngine getSamplingPlanImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    StreamResponse onActionFromExportSamplingPlan() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Log
    void onImported(ErrorReport report) {
        for (String info : report.getInfos()) {
            this.layout.addInfo(info);
        }
        for (String error : report.getErrors()) {
            this.layout.addError(new String[]{error});
        }
    }

    @Log
    public Object onActionFromShowImport() {
        this.showImport = !this.getShowImport();
        return this.importZone.getBody();
    }

    protected void setObservationType(ObservationType observationType) {
        this.samplingFilter.resetFilter();
        ((SamplingFilter)this.samplingFilter.getFilter()).setExpectedObservationType(observationType);
    }

    protected ObservationType getObservationType() {
        ObservationType observationType = ((SamplingFilter)this.samplingFilter.getFilter()).getExpectedObservationType();
        if (observationType == null) {
            observationType = this.waoActivationContext.getObservationType() == null ? ObservationType.FIELD_WORK_OBSERVATION : this.waoActivationContext.getObservationType();
            this.setObservationType(observationType);
        }
        return observationType;
    }

    public String[] getContextForNewSampleRow() {
        WaoActivationContext contextForNewSampleRow = WaoActivationContext.newEmptyContext();
        contextForNewSampleRow.setObservationType(this.getObservationType());
        return contextForNewSampleRow.toStrings();
    }

    public boolean showFieldWorkSamplingPlan() {
        return this.getObservationType() == ObservationType.FIELD_WORK_OBSERVATION;
    }

    public void onActionFromSwitchObservationType() {
        if (this.showFieldWorkSamplingPlan()) {
            this.setObservationType(ObservationType.PHONE_CALL);
        } else {
            this.setObservationType(ObservationType.FIELD_WORK_OBSERVATION);
        }
    }

    public SampleRowDataSource getSampleRows() {
        if (this.sampleRows == null) {
            this.getObservationType();
            ((SamplingFilter)this.samplingFilter.getFilter()).setOrderBy("expectedDate");
            this.sampleRows = new SampleRowDataSource((SamplingFilter)this.samplingFilter.getFilter(), this.serviceSampling);
        }
        return this.sampleRows;
    }

    public BeanModel<SampleRow> getObsdebSamplingPlanModel() {
        if (this.obsdebSamplingPlanModel == null) {
            SampleRowModelFactory sampleRowModelFactory = new SampleRowModelFactory(this.beanModelSource, this.resources, this.connectedUser, this.messages, this.serviceContact);
            this.obsdebSamplingPlanModel = sampleRowModelFactory.newModel(this.getObservationType());
        }
        return this.obsdebSamplingPlanModel;
    }

    public String getBoatDescription() {
        return this.manager.getTooltipBoat(this.sampleRow.getBoat());
    }

    public String getSubstituteDescription() {
        return this.manager.getTooltipBoat(this.substitute);
    }

    public Set<Boat> getSubstitutes() {
        return this.serviceContact.getSubstitutesForBoat(this.sampleRow.getBoat());
    }

    public boolean isBoatSampled() {
        return this.serviceContact.isBoatSampled(this.sampleRow.getBoat(), this.sampleRow);
    }

    protected String[] getContextForBoatOrSubstitute(Boat boat) {
        WaoActivationContext contextForBoat = WaoActivationContext.newEmptyContext();
        contextForBoat.setSampleRowCode(this.sampleRow.getCode());
        contextForBoat.setBoatImmatriculation(Integer.valueOf(boat.getImmatriculation()));
        return contextForBoat.toStrings();
    }

    public String[] getContextForBoat() {
        return this.getContextForBoatOrSubstitute(this.sampleRow.getBoat());
    }

    public String[] getContextForBoats() {
        WaoActivationContext contextForBoats = WaoActivationContext.newEmptyContext();
        contextForBoats.setSampleRowCode(this.sampleRow.getCode());
        return contextForBoats.toStrings();
    }

    public String[] getContextForSubstitute() {
        return this.getContextForBoatOrSubstitute(this.substitute);
    }

    public boolean canEditSampleRow() {
        boolean canEditSampleRow = this.connectedUser.isAdmin() || this.connectedUser.isCoordinator();
        return canEditSampleRow;
    }

    @Log
    public void onActionFromDeleteSampleRow(String sampleRowId) throws WaoBusinessException {
        SampleRow sampleRow = this.serviceSampling.getSampleRow(sampleRowId);
        if (sampleRow == null) {
            throw new IllegalStateException();
        }
        this.serviceSampling.deleteSampleRow(sampleRow);
    }

    public String[] getContextForEditingSampleRow() {
        WaoActivationContext waoActivationContext = WaoActivationContext.newEmptyContext();
        waoActivationContext.setSampleRowId(this.sampleRow.getTopiaId());
        waoActivationContext.setObservationType(this.sampleRow.getObservationType());
        return waoActivationContext.toStrings();
    }

    static /* synthetic */ ConnectedUser access$000(ObsDebSamplingPlan x0) {
        return x0.connectedUser;
    }

    static /* synthetic */ ServiceSampling access$100(ObsDebSamplingPlan x0) {
        return x0.serviceSampling;
    }

    static /* synthetic */ SamplingFilterComponent access$200(ObsDebSamplingPlan x0) {
        return x0.samplingFilter;
    }
}

