/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ConnectedUserImpl;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.tapestry5.services.ApplicationStateManager;

/**
 * ServiceAuthenticationImpl
 *
 * Created: 3 mai 2010
 *
 * @author fdesbois
 * $Id: ServiceAuthenticationImpl.java 845 2010-12-21 11:17:49Z bleny $
 */
public class ServiceAuthenticationImpl implements ServiceAuthentication {

    private final ApplicationStateManager stateManager;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public boolean existConnectedUser() {
        return stateManager.exists(ConnectedUser.class);
    }

    @Override
    public ConnectedUser getConnectedUser() {
        return stateManager.getIfExists(ConnectedUser.class);
    }

    @Override
    public void setConnectedUser(ConnectedUser user) {
        stateManager.set(ConnectedUser.class, user);
    }

    @Override
    public boolean isAllowed(Class<?> page) {
        boolean isAllowed = false;
        if (existConnectedUser()) {
            if (page.isAnnotationPresent(RequiresAuthentication.class)) {

                RequiresAuthentication check =
                        page.getAnnotation(RequiresAuthentication.class);

                ConnectedUser connectedUser = getConnectedUser();

                // Check if user readOnly is allowed
                if (connectedUser.isReadOnly() && ! check.readOnlyAllowed()) {
                    isAllowed = false;
                } else {

                    boolean roleAllowed = false;
                    boolean programAllowed = false;

                    // Check if user role is allowed
                    for (UserRole role : check.allowedRoles()) {
                        if (role.equals(connectedUser.getRole())) {
                            roleAllowed = true;
                        }
                    }

                    // check if program is allowed
                    if (roleAllowed) { // skip if role is not allowed
                        for (ObsProgram program : check.allowedPrograms()) {
                            if (program.equals(connectedUser.getProfile().getObsProgram())) {
                                programAllowed = true;
                            }
                        }
                    }

                    isAllowed = roleAllowed && programAllowed;
                }
            } else {
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    @Override
    public ConnectedUser getNewUserInstance() {
        return new ConnectedUserImpl();
    }

}
