/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappedGridDataSource<K, E extends TopiaEntity>
implements GridDataSource {
    private Logger log = LoggerFactory.getLogger(AbstractMappedGridDataSource.class);
    private Map<K, E> mapResults;
    private List<E> listResults;
    private int nbRows = -1;
    private int nbRowsPerPage;

    public int getAvailableRows() {
        if (this.nbRows < 0) {
            try {
                this.nbRows = this.count();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Count : " + this.nbRows);
                }
            }
            catch (WaoException eee) {
                throw new TapestryException("", (Throwable)eee);
            }
        }
        return this.nbRows;
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Prepare results : " + startIndex + ", " + endIndex);
        }
        this.nbRowsPerPage = endIndex - startIndex + 1;
        try {
            this.mapResults = this.execute(startIndex, endIndex, this.getSortConstraint(sortConstraints));
            this.listResults = new ArrayList(this.mapResults.values());
        }
        catch (WaoException eee) {
            throw new TapestryException("", (Throwable)eee);
        }
    }

    protected abstract Map<K, E> execute(int var1, int var2, SortConstraint var3) throws WaoException;

    protected abstract int count() throws WaoException;

    protected SortConstraint getSortConstraint(List<SortConstraint> sortConstraints) {
        for (SortConstraint constraint : sortConstraints) {
            ColumnSort sort = constraint.getColumnSort();
            if (sort == ColumnSort.UNSORTED) continue;
            return constraint;
        }
        return null;
    }

    public Object getRowValue(int index) {
        if ((index %= this.nbRowsPerPage) >= this.listResults.size()) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Size error : " + index + " / " + this.listResults.size());
            }
            return null;
        }
        return CollectionUtils.get((Object)this.listResults, (int)index);
    }

    public abstract Class<?> getRowType();

    public E get(K key) {
        if (this.mapResults == null) {
            return null;
        }
        return (E)((TopiaEntity)this.mapResults.get(key));
    }

    public List<E> values() {
        if (this.listResults == null) {
            this.listResults = new ArrayList();
        }
        return this.listResults;
    }

    public boolean contains(K key) {
        if (this.mapResults == null) {
            return false;
        }
        return this.mapResults.containsKey(key);
    }
}

