/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ObservationType;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.FilterComponent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.util.EnumSelectModel;

public class SamplingFilterComponent
extends FilterComponent<SamplingFilter> {
    @Parameter(required=false)
    private Boolean showObservationTypes;
    @Parameter(required=false)
    private Boolean showEstimatedTides;
    @Parameter(required=true)
    private String legendMsg;
    @Parameter(required=true)
    private ServiceSampling serviceSampling;
    @Inject
    private Messages messages;
    @Persist
    private SamplingFilterValues possibleValuesForFilter;
    private SelectModel skillZoneSelectModel;
    private SelectModel subPopulationSelectModel;

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public Boolean getFiltersVisible() {
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null && !(filtersVisible = this.getVisibleOnStartup()).booleanValue()) {
            filtersVisible = !this.getFilter().isPeriodFilteredOnly();
        }
        return filtersVisible;
    }

    public void resetFilter() {
        this.setFilter(this.serviceSampling.newSamplingFilter(this.getUser()));
    }

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceSampling.getPossibleValuesForFilter(this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public Boolean getShowEstimatedTides() {
        if (this.showEstimatedTides == null) {
            this.showEstimatedTides = false;
        }
        return this.showEstimatedTides;
    }

    public Boolean getShowObservationTypes() {
        if (this.showObservationTypes == null) {
            this.showObservationTypes = true;
        }
        return this.showObservationTypes;
    }

    public String getLegendMsg() {
        return this.legendMsg;
    }

    public String getFormatForPeriod() {
        String format = this.getUser().isObsDeb() ? "dd/MM/yyyy" : "MM/yyyy";
        return format;
    }

    public SelectModel getSkillZoneSelectModel() {
        if (this.skillZoneSelectModel == null) {
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            Map skillZones = this.getPossibleValuesForFilter().getSkillZones();
            if (skillZones != null) {
                for (Map.Entry skillZone : skillZones.entrySet()) {
                    options.add(new OptionModelImpl((String)skillZone.getValue(), skillZone.getKey()));
                }
            }
            this.skillZoneSelectModel = new SelectModelImpl(null, options);
        }
        return this.skillZoneSelectModel;
    }

    public SelectModel getSubPopulationSelectModel() {
        if (this.subPopulationSelectModel == null) {
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            Map subPopulations = this.getPossibleValuesForFilter().getSubPopulations();
            if (subPopulations != null) {
                for (Map.Entry skillZone : subPopulations.entrySet()) {
                    options.add(new OptionModelImpl((String)skillZone.getValue(), skillZone.getKey()));
                }
            }
            this.subPopulationSelectModel = new SelectModelImpl(null, options);
        }
        return this.subPopulationSelectModel;
    }

    public SelectModel getObservationTypeSelectModel() {
        ObservationType[] allowedObservationTypes = new ObservationType[]{ObservationType.FIELD_WORK_OBSERVATION, ObservationType.PHONE_CALL};
        EnumSelectModel selectModel = new EnumSelectModel(ObservationType.class, this.messages, (Enum[])allowedObservationTypes);
        return selectModel;
    }
}

