/*
 * Decompiled with CFR 0.152.
 */
package winstone.ajp13;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import winstone.Logger;
import winstone.RequestHandlerThread;
import winstone.WinstoneException;
import winstone.ajp13.Ajp13Listener;

public class Ajp13IncomingPacket {
    byte SERVER_FORWARD_REQUEST = (byte)2;
    private int packetLength;
    private byte[] packetBytes;
    private byte packetType;
    private String method;
    private String protocol;
    private String uri;
    private String remoteAddr;
    private String remoteHost;
    private String serverName;
    private int serverPort;
    private boolean isSSL;
    private String[] headers;
    private Map attributes;

    public Ajp13IncomingPacket(InputStream in, RequestHandlerThread handler) throws IOException {
        DataInputStream din = new DataInputStream(in);
        byte[] headerBuffer = new byte[4];
        din.readFully(headerBuffer);
        handler.setRequestStartTime();
        if (headerBuffer[0] != 18 || headerBuffer[1] != 52) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.InvalidHeader"));
        }
        this.packetLength = ((headerBuffer[2] & 0xFF) << 8) + (headerBuffer[3] & 0xFF);
        this.packetBytes = new byte[this.packetLength];
        din.readFully(this.packetBytes);
    }

    public byte parsePacket(String encoding) throws IOException {
        byte type;
        DataInputStream di = new DataInputStream(new ByteArrayInputStream(this.packetBytes));
        this.packetType = di.readByte();
        if (this.packetType != this.SERVER_FORWARD_REQUEST) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.UnknownPacketType", this.packetType + ""));
        }
        if (this.packetBytes[this.packetLength - 1] != -1) {
            throw new WinstoneException(Ajp13Listener.AJP_RESOURCES.getString("Ajp13IncomingPacket.InvalidTerminator"));
        }
        this.method = this.decodeMethodType(di.readByte());
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Method", this.method);
        this.protocol = this.readString(di, encoding);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Protocol", this.protocol);
        this.uri = this.readString(di, encoding);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.URI", this.uri);
        this.remoteAddr = this.readString(di, encoding);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.RemoteAddress", this.remoteAddr);
        this.remoteHost = this.readString(di, encoding);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.RemoteHost", this.remoteHost);
        this.serverName = this.readString(di, encoding);
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.ServerName", this.serverName);
        this.serverPort = di.readShort();
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.ServerPort", "" + this.serverPort);
        this.isSSL = di.readBoolean();
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.SSL", "" + this.isSSL);
        int headerCount = di.readShort();
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.HeaderCount", "" + headerCount);
        this.headers = new String[headerCount];
        for (int n = 0; n < headerCount; ++n) {
            short headerTypeOrLength = di.readShort();
            String headerName = (headerTypeOrLength & 0xFF00) == 40960 ? this.decodeHeaderType(headerTypeOrLength & 0xFFFF) : this.readString(di, encoding, headerTypeOrLength);
            this.headers[n] = headerName + ": " + this.readString(di, encoding);
            Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Header", this.headers[n]);
        }
        this.attributes = new Hashtable();
        while ((type = di.readByte()) != -1) {
            String attName = this.decodeAttributeType(type);
            if (type == 10) {
                attName = this.readString(di, encoding);
            }
            String attValue = this.readString(di, encoding);
            this.attributes.put(attName, attValue);
            Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.Attribute", new String[]{attName, attValue});
        }
        Logger.log(Logger.FULL_DEBUG, Ajp13Listener.AJP_RESOURCES, "Ajp13IncomingPacket.SuccessfullyReadRequest", "" + this.packetLength);
        return this.packetType;
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getURI() {
        return this.uri;
    }

    public String getRemoteAddress() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    private String readString(DataInput di, String encoding) throws IOException {
        return this.readString(di, encoding, di.readShort());
    }

    private String readString(DataInput di, String encoding, int length) throws IOException {
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            di.readByte();
            return "";
        }
        byte[] buf = new byte[length];
        di.readFully(buf);
        di.readByte();
        return new String(buf, encoding);
    }

    private String decodeMethodType(byte methodType) {
        switch (methodType) {
            case 1: {
                return "OPTIONS";
            }
            case 2: {
                return "GET";
            }
            case 3: {
                return "HEAD";
            }
            case 4: {
                return "POST";
            }
            case 5: {
                return "PUT";
            }
            case 6: {
                return "DELETE";
            }
            case 7: {
                return "TRACE";
            }
            case 8: {
                return "PROPFIND";
            }
            case 9: {
                return "PROPPATCH";
            }
            case 10: {
                return "MKCOL";
            }
            case 11: {
                return "COPY";
            }
            case 12: {
                return "MOVE";
            }
            case 13: {
                return "LOCK";
            }
            case 14: {
                return "UNLOCK";
            }
            case 15: {
                return "ACL";
            }
            case 16: {
                return "REPORT";
            }
            case 17: {
                return "VERSION-CONTROL";
            }
            case 18: {
                return "CHECKIN";
            }
            case 19: {
                return "CHECKOUT";
            }
            case 20: {
                return "UNCHECKOUT";
            }
            case 21: {
                return "SEARCH";
            }
            case 22: {
                return "MKWORKSPACE";
            }
            case 23: {
                return "UPDATE";
            }
            case 24: {
                return "LABEL";
            }
            case 25: {
                return "MERGE";
            }
            case 26: {
                return "BASELINE_CONTROL";
            }
            case 27: {
                return "MKACTIVITY";
            }
        }
        return "UNKNOWN";
    }

    private String decodeHeaderType(int headerType) {
        switch (headerType) {
            case 40961: {
                return "Accept";
            }
            case 40962: {
                return "Accept-Charset";
            }
            case 40963: {
                return "Accept-Encoding";
            }
            case 40964: {
                return "Accept-Language";
            }
            case 40965: {
                return "Authorization";
            }
            case 40966: {
                return "Connection";
            }
            case 40967: {
                return "Content-Type";
            }
            case 40968: {
                return "Content-Length";
            }
            case 40969: {
                return "Cookie";
            }
            case 40970: {
                return "Cookie2";
            }
            case 40971: {
                return "Host";
            }
            case 40972: {
                return "Pragma";
            }
            case 40973: {
                return "Referer";
            }
            case 40974: {
                return "User-Agent";
            }
        }
        return null;
    }

    private String decodeAttributeType(byte attributeType) {
        switch (attributeType) {
            case 1: {
                return "context";
            }
            case 2: {
                return "servlet_path";
            }
            case 3: {
                return "remote_user";
            }
            case 4: {
                return "auth_type";
            }
            case 5: {
                return "query_string";
            }
            case 6: {
                return "jvm_route";
            }
            case 7: {
                return "ssl_cert";
            }
            case 8: {
                return "ssl_cipher";
            }
            case 9: {
                return "ssl_session";
            }
            case 10: {
                return "req_attribute";
            }
            case 11: {
                return "ssl_key_size";
            }
            case 12: {
                return "secret";
            }
            case 13: {
                return "stored_method";
            }
        }
        return null;
    }
}

