/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Connexion;
import fr.ifremer.wao.ui.pages.Unavailable;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiresAuthenticationFilter
implements ComponentRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequiresAuthenticationFilter.class);
    private final PageRenderLinkSource pageRender;
    private final ComponentSource componentSource;
    private final Response response;
    private final ServiceAuthentication serviceAuthentication;

    public RequiresAuthenticationFilter(PageRenderLinkSource renderLinkSource, ComponentSource componentSource, Response response, ServiceAuthentication serviceAuthentication) {
        this.pageRender = renderLinkSource;
        this.componentSource = componentSource;
        this.response = response;
        this.serviceAuthentication = serviceAuthentication;
        if (logger.isTraceEnabled()) {
            logger.trace("Construct");
        }
    }

    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        Object[] context;
        if (logger.isTraceEnabled()) {
            logger.trace("handleComponentEvent");
        }
        if (this.dispatchedToLoginPage(context = this.prepareContext(parameters.getActivePageName(), parameters.getPageActivationContext()))) {
            return;
        }
        handler.handleComponentEvent(parameters);
    }

    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        Object[] context;
        if (logger.isTraceEnabled()) {
            logger.trace("handlePageRender");
        }
        if (this.dispatchedToLoginPage(context = this.prepareContext(parameters.getLogicalPageName(), parameters.getActivationContext()))) {
            return;
        }
        handler.handlePageRender(parameters);
    }

    protected Object[] prepareContext(String pageName, EventContext activationContext) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(pageName);
        for (int i = 0; i < activationContext.getCount(); ++i) {
            list.add(activationContext.get(Object.class, i));
        }
        return list.toArray(new Object[list.size()]);
    }

    private boolean dispatchedToLoginPage(Object ... context) throws IOException {
        String pageName = (String)context[0];
        Component page = this.componentSource.getPage(pageName);
        if (logger.isTraceEnabled()) {
            logger.trace("Page name : " + pageName);
            logger.trace("Page class : " + page.getClass());
            logger.trace("RequiresLogin annotation : " + page.getClass().isAnnotationPresent(RequiresAuthentication.class));
            logger.trace("User in session : " + this.serviceAuthentication.existConnectedUser());
            logger.trace("Activation context : " + Arrays.toString(context));
        }
        if (!page.getClass().isAnnotationPresent(RequiresAuthentication.class)) {
            return false;
        }
        Class<Connexion> redirectPage = Connexion.class;
        if (this.serviceAuthentication.existConnectedUser()) {
            ConnectedUser user = this.serviceAuthentication.getConnectedUser();
            if (user.getRole() == null) {
                this.serviceAuthentication.setConnectedUser(null);
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("User connected : " + user);
                logger.trace("User role : " + user.getRole());
                logger.trace("User allowed : " + this.serviceAuthentication.isAllowed(page.getClass()));
            }
            if (this.serviceAuthentication.isAllowed(page.getClass())) {
                return false;
            }
            redirectPage = Unavailable.class;
        }
        Link link = this.pageRender.createPageRenderLinkWithContext(redirectPage, context);
        if (logger.isTraceEnabled()) {
            logger.trace("Redirection to " + redirectPage.getSimpleName() + " page...");
        }
        this.response.sendRedirect(link);
        return true;
    }
}

