/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.pages.Administration;
import fr.ifremer.wao.ui.pages.Boats;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.pages.Index;
import fr.ifremer.wao.ui.pages.SamplingPlan;
import fr.ifremer.wao.ui.pages.Synthesis;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.Request;
import org.nuiton.i18n.I18n;
import org.slf4j.Logger;

public class Layout {
    @Inject
    private WaoManager manager;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String pageTitle;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String contentId;
    @InjectComponent
    private FeedBack contentFeedback;
    @Inject
    private Request request;
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    @Inject
    private ServiceAuthentication serviceAuthentication;
    private boolean fatal = false;
    private Map<String, String> menuItems;
    @Property
    private Map.Entry<String, String> menuItem;
    @Inject
    private ComponentResources resources;
    @Inject
    private PageRenderLinkSource pageRender;

    boolean afterRender() {
        if (this.fatal && this.contentFeedback.hasErrors() && !this.contentFeedback.hasBeeanReloaded()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("[ FATAL ] Reload the page to display errors");
            }
            this.contentFeedback.reload();
            return false;
        }
        this.contentFeedback.clearErrors();
        this.fatal = false;
        return true;
    }

    public boolean isDevEnvironment() {
        return this.manager.isDevEnvironment();
    }

    public boolean isCurrentUserExists() {
        return this.serviceAuthentication.existConnectedUser();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public ConnectedUser getConnectedUser() {
        return this.serviceAuthentication.getConnectedUser();
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    public Map getMenuItems() {
        if (this.menuItems == null) {
            Messages messages = this.resources.getMessages();
            LinkedHashMap<String, Class<Administration>> pagesInMenu = new LinkedHashMap<String, Class<Administration>>();
            pagesInMenu.put(messages.get(I18n.n_((String)"wao.ui.page.SamplingPlan.title", (Object[])new Object[0])), SamplingPlan.class);
            pagesInMenu.put(messages.get(I18n.n_((String)"wao.ui.page.Boats.title", (Object[])new Object[0])), Boats.class);
            pagesInMenu.put(messages.get(I18n.n_((String)"wao.ui.page.Contacts.title", (Object[])new Object[0])), Contacts.class);
            pagesInMenu.put(messages.get(I18n.n_((String)"wao.ui.page.Synthesis.title", (Object[])new Object[0])), Synthesis.class);
            pagesInMenu.put(messages.get(I18n.n_((String)"wao.ui.page.Administration.title", (Object[])new Object[0])), Administration.class);
            this.menuItems = new LinkedHashMap();
            for (Map.Entry menuEntry : pagesInMenu.entrySet()) {
                String linkName = (String)menuEntry.getKey();
                Class page = (Class)menuEntry.getValue();
                if (!this.serviceAuthentication.isAllowed(page)) continue;
                Link link = this.pageRender.createPageRenderLinkWithContext(page, new Object[0]);
                String url = link.toAbsoluteURI();
                this.menuItems.put(url, linkName);
            }
        }
        return this.menuItems;
    }

    public boolean displayBody() {
        return !this.fatal;
    }

    public void addInfo(String message) {
        this.contentFeedback.addInfo(message);
    }

    public void addError(String ... message) {
        this.contentFeedback.addError(message);
    }

    public void addFatal(String message) {
        this.contentFeedback.addError(new String[]{message});
        this.fatal = true;
    }

    @Log
    Object onActionFromExit() {
        this.serviceAuthentication.setConnectedUser(null);
        this.request.getSession(false).invalidate();
        return Index.class;
    }

    @Log
    Object onActionFromChangeLocale() {
        this.manager.changeLocale();
        return this;
    }
}

