/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.GlobalIndicatorValue;
import fr.ifremer.wao.bean.GlobalSynthesisParameters;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.CompanyImpl;
import fr.ifremer.wao.entity.Indicator;
import fr.ifremer.wao.entity.IndicatorLevel;
import fr.ifremer.wao.entity.UserProfile;
import fr.ifremer.wao.entity.UserProfileImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceSynthesis;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Administration;
import fr.ifremer.wao.ui.services.WaoManager;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.Validate;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.EnumSelectModel;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR}, readOnlyAllowed=false)
@Import(stylesheet={"context:css/administration.css"}, library={"context:js/administration.js"})
public class Administration {
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser currentUser;
    @Inject
    private Logger log;
    @Inject
    private WaoManager manager;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceCartography serviceCartography;
    @Inject
    private TypeCoercer typeCoercer;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Property
    private String companyId;
    @Property
    private String userId;
    @Persist
    private List<Company> companies;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<Company> companiesSelectModel;
    private Company company;
    private GenericSelectModel<WaoUser> usersSelectModel;
    @InjectComponent
    private BeanEditForm userForm;
    private boolean addNewCompanySelected;
    private boolean deleteCompanySelected;
    private boolean addNewUserSelected;
    private boolean showUserSelected;
    private boolean deleteUserSelected;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    private List<WaoUser> users;
    @Property
    private WaoUser user;
    @InjectComponent
    private Zone userFormZone;
    @Inject
    private BeanModelSource beanModelSource;
    @Persist
    private WaoUser userEdited;
    @Persist
    private BeanModel<WaoUser> userModel;
    @Property
    private boolean generatePassword;
    @Property
    private String password;
    @InjectComponent
    private Zone userRoleZone;
    private SelectModel userRoleSelectModel;
    @Persist
    private List<UserProfile> editedUserProfiles;
    @Persist
    @Property
    private UserProfile profile;
    @Persist
    private UserProfile editedProfile;
    @Persist
    @Property
    private boolean readOnly;
    @Property
    private UserRole role;
    @Property
    private int profileIndex;
    @Property
    private boolean refreshUserRoleZone;
    @Inject
    private ServiceSynthesis serviceSynthesis;
    private GlobalSynthesisParameters globalSynthesisParameters;
    @Property
    private Indicator indicator;
    @InjectComponent
    private Form synthesisParametersForm;
    @Property
    @Validate(value="required")
    private String comment;
    @Property
    private IndicatorLevel indicatorLevel;
    @Inject
    private Messages messages;

    void setupRender() throws WaoException {
        this.companies = null;
        this.getCompanies();
        this.userEdited = null;
        this.userModel = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.companyId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.userId = (String)ec.get(String.class, 1);
            }
        } else if (this.currentUser.isCoordinator()) {
            this.companyId = this.currentUser.getCompany().getId();
        }
    }

    Object[] onPassivate() {
        return new String[]{this.companyId, this.userId};
    }

    void afterRender() {
        this.javaScriptSupport.addScript("new AdminUserSelect();", new Object[0]);
    }

    public ImportEngine getFishingZoneImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getSamplingPlanImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Log
    public ImportEngine getBoatImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getActivityCalendarImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getTerrestrialLocationsImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImportEngine getTerrestrialDivisionsImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public InputStream getActivityCalendarLogFile() {
        return this.getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_IMPORT);
    }

    public InputStream getActivityCalendarAccessLogFile() {
        return this.getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_ACCESS);
    }

    private InputStream getActivityCalendarLogFile(WaoProperty property) {
        InputStream result;
        block6: {
            result = null;
            try {
                switch (8.$SwitchMap$fr$ifremer$wao$WaoProperty[property.ordinal()]) {
                    case 1: {
                        result = this.serviceBoat.getActivityCalendarLogAccessFile();
                        break;
                    }
                    case 2: {
                        result = this.serviceBoat.getActivityCalendarLogFile();
                    }
                }
            }
            catch (FileNotFoundException eee) {
                if (!this.log.isInfoEnabled()) break block6;
                this.log.info("Not existing log file for " + property);
            }
        }
        return result;
    }

    public boolean isActivityCalendarImportRun() {
        return this.manager.isActivityCalendarImportRun();
    }

    public ImportEngine getBoatDistrictImportEngine() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Log
    void onImported(ErrorReport report) {
        for (String info : report.getInfos()) {
            this.layout.addInfo(info);
        }
        for (String error : report.getErrors()) {
            this.layout.addError(new String[]{error});
        }
    }

    public List<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            this.companies = this.serviceUser.getCompanies(false);
        }
        return this.companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() throws WaoException {
        if (this.companiesSelectModel == null) {
            this.companiesSelectModel = new GenericSelectModel(this.getCompanies(), Company.class, "name", "id", this.propertyAccess);
        }
        return this.companiesSelectModel;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            this.company = this.companyId != null ? (Company)this.getCompaniesSelectModel().findObject(this.companyId) : new CompanyImpl();
        }
        return this.company;
    }

    public boolean isUsersAvailable() throws WaoException {
        return !StringUtils.isEmpty((String)this.getCompany().getId()) && this.getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        this.addNewCompanySelected = true;
    }

    void onSelectedFromDeleteCompany() {
        this.deleteCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (this.addNewCompanySelected) {
            this.companyId = null;
        } else if (this.deleteCompanySelected && this.companyId != null) {
            this.company = (Company)this.getCompaniesSelectModel().findObject(this.companyId);
            try {
                this.serviceUser.deleteCompany(this.company);
                this.companyId = null;
                this.company = null;
                this.layout.addInfo("Soci\u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
        this.userId = null;
        this.userEdited = null;
    }

    void onSuccessFromCompany() throws WaoException {
        this.serviceUser.createUpdateCompany(this.company);
        this.companyId = this.company.getId();
    }

    @Log
    public List<WaoUser> getUsers() {
        if (this.users == null) {
            this.users = this.serviceUser.getUsersByCompany(this.getCompany());
        }
        return this.users;
    }

    private WaoUser findUser(String id) {
        for (WaoUser user : this.getUsers()) {
            if (!user.getId().equals(id)) continue;
            return user;
        }
        return null;
    }

    public String getUserOptionStyle() {
        String result = "";
        if (!this.user.getActive()) {
            result = "line-through";
        }
        return result;
    }

    @Log
    void onSelectedFromAddNewUser() {
        this.addNewUserSelected = true;
    }

    @Log
    void onSelectedFromDeleteUser() {
        this.deleteUserSelected = true;
    }

    @Log
    void onSelectedFromShowUser() {
        this.showUserSelected = true;
    }

    @Log
    void onSuccessFromUserActionsForm() throws WaoException {
        if (this.addNewUserSelected) {
            this.userId = null;
        } else if (this.deleteUserSelected && this.userId != null) {
            this.userEdited = this.findUser(this.userId);
            try {
                this.serviceUser.deleteUser(this.userEdited);
                this.userEdited = null;
                this.userId = null;
                this.layout.addInfo("Utilisateur supprim\u00e9 avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        } else if (this.showUserSelected && this.userId != null) {
            this.userEdited = this.findUser(this.userId);
        }
        this.editedUserProfiles = null;
        this.editedProfile = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("'User id : " + this.userId);
        }
    }

    public WaoUser getUserEdited() throws WaoException {
        if (this.userEdited == null) {
            if (this.userId == null) {
                this.userEdited = this.serviceUser.getNewUser(this.getCompany());
                this.generatePassword = true;
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User exist in selectModel : " + this.userId);
                }
                this.userEdited = this.findUser(this.userId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(">>User : " + this.userEdited);
                    this.log.debug(">>User.active : " + this.userEdited.isActive());
                    this.log.debug(">>User.login : " + this.userEdited.getLogin());
                }
            }
        }
        return this.userEdited;
    }

    public BeanModel<WaoUser> getUserModel() {
        if (this.userModel == null) {
            this.userModel = this.beanModelSource.createEditModel(WaoUser.class, this.messages);
            this.userModel.add("generatePassword", null);
            this.userModel.add("userRole", null);
            this.userModel.include(new String[]{"firstName", "lastName", "login", "generatePassword", "password", "phoneNumber", "mammalsNotifications", "active", "userRole"});
        }
        return this.userModel;
    }

    @Log
    void onSelectedFromUserForm() {
        this.refreshUserRoleZone = false;
    }

    @Log
    void onValidateFormFromUserForm() {
        this.userForm.clearErrors();
        if (CollectionUtils.isEmpty((Collection)this.getEditedUserProfiles())) {
            this.userForm.recordError("L'utilisateur doit au minimum avoir un r\u00f4le.");
        } else {
            this.getUserEdited().clearUserProfile(this.currentUser.getProfile().getObsProgram());
            this.getUserEdited().addAllUserProfile((Collection)this.getEditedUserProfiles());
        }
    }

    @Log
    Object onSuccessFromUserForm() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("User : " + this.userEdited);
            this.log.debug("User.active : " + this.userEdited.isActive());
            this.log.debug("User.login : " + this.userEdited.getLogin());
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            this.userEdited.setPassword(this.password);
            this.userEdited.setPasswordChanged(true);
        }
        try {
            this.serviceUser.createUpdateUser(this.userEdited, this.generatePassword);
            this.userId = this.userEdited.getId();
        }
        catch (WaoBusinessException eee) {
            if (eee.getType().equals((Object)WaoBusinessException.Type.SMTP_NOT_FOUND)) {
                this.layout.addInfo(eee.getMessage());
                this.userId = this.userEdited.getId();
            }
            this.layout.addError(new String[]{eee.getMessage()});
        }
        return this;
    }

    @Log
    Object onFailureFromUserForm() {
        return this.userForm;
    }

    @Log
    public UserProfile getEditedProfile() {
        if (this.editedProfile == null) {
            this.editedProfile = new UserProfileImpl();
            this.editedProfile.setObsProgram(this.currentUser.getProfile().getObsProgram());
        }
        return this.editedProfile;
    }

    @Log
    public SelectModel getUserRoleSelectModel() {
        if (this.userRoleSelectModel == null) {
            UserRole[] allowedRoles = UserRole.getAllowedRoles((ObsProgram)this.currentUser.getProfile().getObsProgram(), (UserRole)this.currentUser.getProfile().getUserRole());
            return new EnumSelectModel(UserRole.class, this.messages, (Enum[])allowedRoles);
        }
        return this.userRoleSelectModel;
    }

    private OptionModel newUserRoleOption(UserRole role) {
        return new OptionModelImpl(role.getTranslation(), (Object)role);
    }

    @Log
    Zone onValueChangedFromUserRole(String value) {
        if (StringUtils.isEmpty((String)value)) {
            this.getEditedProfile().setUserRole(null);
        } else {
            this.getEditedProfile().setUserRole(UserRole.valueOf((String)value));
        }
        return this.userRoleZone;
    }

    @Log
    void onChangeFromReadOnly(boolean value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("readOnly value changed to " + value);
        }
        this.readOnly = value;
    }

    @Log
    public List<UserProfile> getEditedUserProfiles() {
        if (this.editedUserProfiles == null && this.getUserEdited() != null) {
            this.editedUserProfiles = this.getUserEdited().getUserProfile(this.currentUser.getProfile().getObsProgram());
        }
        return this.editedUserProfiles;
    }

    @Log
    Zone onActionFromAddRole() {
        if (this.getEditedProfile() == null || this.getEditedProfile().getUserRoleOrdinal() == null) {
            return null;
        }
        boolean profileCanBeAdded = true;
        for (UserProfile userProfile : this.getEditedUserProfiles()) {
            if (userProfile.getUserRole() != this.getEditedProfile().getUserRole()) continue;
            profileCanBeAdded = false;
        }
        if (profileCanBeAdded) {
            this.getEditedProfile().setCanWrite(Boolean.valueOf(!this.readOnly));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add user profile : " + this.getEditedProfile().getDescription());
            }
            this.getEditedUserProfiles().add(this.getEditedProfile());
        }
        this.editedProfile = null;
        this.readOnly = false;
        return this.userRoleZone;
    }

    @Log
    Zone onActionFromRemoveRole(int roleIndex) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("edited profiles before remove : " + this.getEditedUserProfiles());
        }
        this.getEditedUserProfiles().remove(roleIndex);
        if (this.log.isDebugEnabled()) {
            this.log.debug("edited profiles after remove : " + this.getEditedUserProfiles());
        }
        return this.userRoleZone;
    }

    public GlobalSynthesisParameters getGlobalSynthesisParameters() {
        if (this.globalSynthesisParameters == null) {
            this.globalSynthesisParameters = this.serviceSynthesis.getGlobalSynthesisParameters();
        }
        return this.globalSynthesisParameters;
    }

    void onValidateFromSynthesisParametersForm() {
    }

    void onSuccessFromSynthesisParametersForm() {
        this.serviceSynthesis.updateGlobalSynthesisParameters(this.getGlobalSynthesisParameters(), this.currentUser.getUser(), this.comment);
        this.getGlobalSynthesisParameters();
    }

    public GlobalIndicatorValue getGlobalIndicatorValue() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("indicatorLevel is " + this.indicatorLevel);
            this.log.debug(this.indicatorLevel.getLevel() + " is " + GlobalIndicatorValue.valueOf((int)this.indicatorLevel.getLevel()));
        }
        return GlobalIndicatorValue.valueOf((int)this.indicatorLevel.getLevel());
    }

    static /* synthetic */ ServiceReferential access$000(Administration x0) {
        return x0.serviceReferential;
    }

    static /* synthetic */ ConnectedUser access$100(Administration x0) {
        return x0.currentUser;
    }

    static /* synthetic */ ServiceSampling access$200(Administration x0) {
        return x0.serviceSampling;
    }

    static /* synthetic */ ServiceBoat access$300(Administration x0) {
        return x0.serviceBoat;
    }

    static /* synthetic */ ServiceCartography access$400(Administration x0) {
        return x0.serviceCartography;
    }
}

