/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Map;
import winstone.HostGroup;
import winstone.Launcher;
import winstone.Listener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.RequestHandlerThread;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;
import winstone.WinstoneInputStream;
import winstone.WinstoneOutputStream;
import winstone.WinstoneRequest;
import winstone.WinstoneResponse;

public class HttpListener
implements Listener,
Runnable {
    protected static int LISTENER_TIMEOUT = 5000;
    protected static int CONNECTION_TIMEOUT = 60000;
    protected static int BACKLOG_COUNT = 5000;
    protected static boolean DEFAULT_HNL = false;
    protected static int KEEP_ALIVE_TIMEOUT = 10000;
    protected static int KEEP_ALIVE_SLEEP = 20;
    protected static int KEEP_ALIVE_SLEEP_MAX = 500;
    protected HostGroup hostGroup;
    protected ObjectPool objectPool;
    protected boolean doHostnameLookups;
    protected int listenPort;
    protected String listenAddress;
    protected boolean interrupted;

    protected HttpListener() {
    }

    public HttpListener(Map args, ObjectPool objectPool, HostGroup hostGroup) throws IOException {
        this.hostGroup = hostGroup;
        this.objectPool = objectPool;
        this.listenPort = Integer.parseInt(WebAppConfiguration.stringArg(args, this.getConnectorName() + "Port", "" + this.getDefaultPort()));
        this.listenAddress = WebAppConfiguration.stringArg(args, this.getConnectorName() + "ListenAddress", null);
        this.doHostnameLookups = WebAppConfiguration.booleanArg(args, this.getConnectorName() + "DoHostnameLookups", DEFAULT_HNL);
    }

    public boolean start() {
        if (this.listenPort < 0) {
            return false;
        }
        this.interrupted = false;
        Thread thread = new Thread((Runnable)this, Launcher.RESOURCES.getString("Listener.ThreadName", new String[]{this.getConnectorName(), "" + this.listenPort}));
        thread.setDaemon(true);
        thread.start();
        return true;
    }

    protected int getDefaultPort() {
        return 8080;
    }

    protected String getConnectorName() {
        return this.getConnectorScheme();
    }

    protected String getConnectorScheme() {
        return "http";
    }

    protected ServerSocket getServerSocket() throws IOException {
        ServerSocket ss = this.listenAddress == null ? new ServerSocket(this.listenPort, BACKLOG_COUNT) : new ServerSocket(this.listenPort, BACKLOG_COUNT, InetAddress.getByName(this.listenAddress));
        return ss;
    }

    public void run() {
        try {
            ServerSocket ss = this.getServerSocket();
            ss.setSoTimeout(LISTENER_TIMEOUT);
            Logger.log(Logger.INFO, Launcher.RESOURCES, "HttpListener.StartupOK", new String[]{this.getConnectorName().toUpperCase(), this.listenPort + ""});
            while (!this.interrupted) {
                Socket s = null;
                try {
                    s = ss.accept();
                }
                catch (InterruptedIOException err) {
                    s = null;
                }
                if (s == null) continue;
                this.objectPool.handleRequest(s, this);
            }
            ss.close();
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, Launcher.RESOURCES, "HttpListener.ShutdownError", this.getConnectorName().toUpperCase(), err);
        }
        Logger.log(Logger.INFO, Launcher.RESOURCES, "HttpListener.ShutdownOK", this.getConnectorName().toUpperCase());
    }

    public void destroy() {
        this.interrupted = true;
    }

    public void allocateRequestResponse(Socket socket, InputStream inSocket, OutputStream outSocket, RequestHandlerThread handler, boolean iAmFirst) throws SocketException, IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "HttpListener.AllocatingRequest", Thread.currentThread().getName());
        socket.setSoTimeout(CONNECTION_TIMEOUT);
        WinstoneInputStream inData = new WinstoneInputStream(inSocket);
        WinstoneOutputStream outData = new WinstoneOutputStream(outSocket, false);
        WinstoneRequest req = this.objectPool.getRequestFromPool();
        WinstoneResponse rsp = this.objectPool.getResponseFromPool();
        outData.setResponse(rsp);
        req.setInputStream(inData);
        rsp.setOutputStream(outData);
        rsp.setRequest(req);
        req.setHostGroup(this.hostGroup);
        handler.setRequest(req);
        handler.setResponse(rsp);
        handler.setInStream(inData);
        handler.setOutStream(outData);
        rsp.setHeader("Server", Launcher.RESOURCES.getString("ServerVersion"));
    }

    public void deallocateRequestResponse(RequestHandlerThread handler, WinstoneRequest req, WinstoneResponse rsp, WinstoneInputStream inData, WinstoneOutputStream outData) throws IOException {
        handler.setInStream(null);
        handler.setOutStream(null);
        handler.setRequest(null);
        handler.setResponse(null);
        if (req != null) {
            this.objectPool.releaseRequestToPool(req);
        }
        if (rsp != null) {
            this.objectPool.releaseResponseToPool(rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseURI(RequestHandlerThread handler, WinstoneRequest req, WinstoneResponse rsp, WinstoneInputStream inData, Socket socket, boolean iAmFirst) throws IOException {
        this.parseSocketInfo(socket, req);
        socket.setSoTimeout(KEEP_ALIVE_TIMEOUT);
        byte[] uriBuffer = null;
        try {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "HttpListener.WaitingForURILine");
            uriBuffer = inData.readLine();
        }
        catch (InterruptedIOException err) {
            if (iAmFirst) {
                throw err;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                socket.setSoTimeout(CONNECTION_TIMEOUT);
            }
            catch (Throwable err) {}
        }
        handler.setRequestStartTime();
        String uriLine = new String(uriBuffer);
        if (uriLine.trim().equals("")) {
            throw new SocketException("Empty URI Line");
        }
        String servletURI = this.parseURILine(uriLine, req, rsp);
        this.parseHeaders(req, inData);
        rsp.extractRequestKeepAliveHeader(req);
        int contentLength = req.getContentLength();
        if (contentLength != -1) {
            inData.setContentLength(contentLength);
        }
        return servletURI;
    }

    public void releaseSocket(Socket socket, InputStream inSocket, OutputStream outSocket) throws IOException {
        inSocket.close();
        outSocket.close();
        socket.close();
    }

    protected void parseSocketInfo(Socket socket, WinstoneRequest req) throws IOException {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "HttpListener.ParsingSocketInfo");
        req.setScheme(this.getConnectorScheme());
        req.setServerPort(socket.getLocalPort());
        req.setLocalPort(socket.getLocalPort());
        req.setLocalAddr(socket.getLocalAddress().getHostAddress());
        req.setRemoteIP(socket.getInetAddress().getHostAddress());
        req.setRemotePort(socket.getPort());
        if (this.doHostnameLookups) {
            req.setServerName(socket.getLocalAddress().getHostName());
            req.setRemoteName(socket.getInetAddress().getHostName());
            req.setLocalName(socket.getLocalAddress().getHostName());
        } else {
            req.setServerName(socket.getLocalAddress().getHostAddress());
            req.setRemoteName(socket.getInetAddress().getHostAddress());
            req.setLocalName(socket.getLocalAddress().getHostAddress());
        }
    }

    public boolean processKeepAlive(WinstoneRequest request, WinstoneResponse response, InputStream inSocket) throws IOException, InterruptedException {
        boolean continueFlag = !response.closeAfterRequest();
        return continueFlag;
    }

    private String parseURILine(String uriLine, WinstoneRequest req, WinstoneResponse rsp) {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "HttpListener.UriLine", uriLine.trim());
        int spacePos = uriLine.indexOf(32);
        if (spacePos == -1) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HttpListener.ErrorUriLine", uriLine));
        }
        String method = uriLine.substring(0, spacePos).toUpperCase();
        String fullURI = null;
        String remainder = uriLine.substring(spacePos + 1);
        if ((spacePos = remainder.indexOf(32)) == -1) {
            fullURI = this.trimHostName(remainder.trim());
            req.setProtocol("HTTP/0.9");
            rsp.setProtocol("HTTP/0.9");
        } else {
            fullURI = this.trimHostName(remainder.substring(0, spacePos).trim());
            String protocol = remainder.substring(spacePos + 1).trim().toUpperCase();
            if (!protocol.startsWith("HTTP/")) {
                protocol = "HTTP/1.0";
            }
            req.setProtocol(protocol);
            rsp.setProtocol(protocol);
        }
        req.setMethod(method);
        return fullURI;
    }

    private String trimHostName(String input) {
        if (input == null) {
            return null;
        }
        if (input.startsWith("/")) {
            return input;
        }
        int hostStart = input.indexOf("://");
        if (hostStart == -1) {
            return input;
        }
        String hostName = input.substring(hostStart + 3);
        int pathStart = hostName.indexOf(47);
        if (pathStart == -1) {
            return "/";
        }
        return hostName.substring(pathStart);
    }

    public void parseHeaders(WinstoneRequest req, WinstoneInputStream inData) throws IOException {
        ArrayList<String> headerList = new ArrayList<String>();
        if (!req.getProtocol().startsWith("HTTP/0")) {
            byte[] headerBuffer = inData.readLine();
            String headerLine = new String(headerBuffer);
            while (headerLine.trim().length() > 0) {
                if (headerLine.indexOf(58) != -1) {
                    headerList.add(headerLine.trim());
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "HttpListener.Header", headerLine.trim());
                }
                headerBuffer = inData.readLine();
                headerLine = new String(headerBuffer);
            }
        }
        req.parseHeaders(headerList);
    }
}

