/*
 * Decompiled with CFR 0.152.
 */
package winstone.cluster;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import winstone.Logger;
import winstone.WinstoneSession;
import winstone.cluster.SimpleCluster;

public class ClusterSessionSearch
implements Runnable {
    final int TIMEOUT = 2000;
    public static final byte SESSION_CHECK_TYPE = 49;
    public static final String SESSION_NOT_FOUND = "NOTFOUND";
    public static final String SESSION_FOUND = "FOUND";
    public static final String SESSION_RECEIVED = "OK";
    private boolean isFinished = false;
    private WinstoneSession result;
    private String searchWebAppHostname;
    private String searchWebAppPrefix;
    private String searchId;
    private String searchAddressPort;
    private int controlPort;

    public ClusterSessionSearch(String webAppPrefix, String hostName, String sessionId, String ipPort, int controlPort) {
        this.searchWebAppHostname = hostName;
        this.searchWebAppPrefix = webAppPrefix;
        this.searchId = sessionId;
        this.searchAddressPort = ipPort;
        this.result = null;
        this.controlPort = controlPort;
        Thread searchThread = new Thread(this);
        searchThread.setDaemon(true);
        searchThread.start();
    }

    public void run() {
        try {
            int colonPos = this.searchAddressPort.indexOf(58);
            String ipAddress = this.searchAddressPort.substring(0, colonPos);
            String port = this.searchAddressPort.substring(colonPos + 1);
            Socket controlConnection = new Socket(ipAddress, Integer.parseInt(port));
            controlConnection.setSoTimeout(2000);
            OutputStream out = controlConnection.getOutputStream();
            out.write(49);
            out.flush();
            ObjectOutputStream outControl = new ObjectOutputStream(out);
            outControl.writeInt(this.controlPort);
            outControl.writeUTF(this.searchId);
            outControl.writeUTF(this.searchWebAppHostname);
            outControl.writeUTF(this.searchWebAppPrefix);
            outControl.flush();
            InputStream in = controlConnection.getInputStream();
            ObjectInputStream inSession = new ObjectInputStream(in);
            String reply = inSession.readUTF();
            if (reply != null && reply.equals(SESSION_FOUND)) {
                WinstoneSession session = (WinstoneSession)inSession.readObject();
                outControl.writeUTF(SESSION_RECEIVED);
                this.result = session;
            }
            outControl.close();
            inSession.close();
            out.close();
            in.close();
            controlConnection.close();
        }
        catch (Throwable err) {
            Logger.log(Logger.WARNING, SimpleCluster.CLUSTER_RESOURCES, "ClusterSessionSearch.Error", err);
        }
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public WinstoneSession getResult() {
        return this.result;
    }

    public void destroy() {
    }

    public String getAddressPort() {
        return this.searchAddressPort;
    }
}

