/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.PieChartData;
import fr.ifremer.wao.service.ServiceChart;
import fr.ifremer.wao.ui.pages.PieChart;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementation of {@link ServiceChart} that create urls to charts.
 * This implementation only redirect to Wao pages like for example {@link PieChart}.
 * <p />
 * Created: 1 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: ServiceChartImpl.java 650 2010-10-03 15:14:48Z fdesbois $
 */
public class ServiceChartImpl extends ServiceChartServlet {

    private static final Logger logger = LoggerFactory.getLogger(ServiceChartImpl.class);

    /** Service used to create links */
    private PageRenderLinkSource pageRender;

    public ServiceChartImpl(PageRenderLinkSource pageRender) {
        this.pageRender = pageRender;
    }

    @Override
    public String getPieChartUrl(PieChartData data, int size, boolean thumb) {
        // Create link to PieChart. This page is used to redirect
        // data to the correct chartServlet
        Link link = pageRender.createPageRenderLinkWithContext(
                PieChart.class, data, size, thumb);

        return getBaseUrl() + link.toAbsoluteURI();
    }

    @Override
    protected String getBaseUrl() {
        // Get only the first element in the server_path which is the host name of the server
        String[] res = WaoProperty.SERVER_PATH.getValue().split("/");
        return "http://" + res[0];
    }

}
