/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Connexion;
import fr.ifremer.wao.ui.pages.Unavailable;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.ComponentSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * RequiresLoginFilter
 *
 * Created: 3 mai 2010
 *
 * @author fdesbois
 * $Id: RequiresAuthenticationFilter.java 513 2010-06-12 18:47:55Z fdesbois $
 */
public class RequiresAuthenticationFilter implements ComponentRequestFilter {

    private static final Logger logger =
            LoggerFactory.getLogger(RequiresAuthenticationFilter.class);

    private final PageRenderLinkSource pageRender;

    private final ComponentSource componentSource;

    private final Response response;

    private final ServiceAuthentication serviceAuthentication;

    public RequiresAuthenticationFilter(PageRenderLinkSource renderLinkSource,
            ComponentSource componentSource, Response response,
            ServiceAuthentication serviceAuthentication) {
        this.pageRender = renderLinkSource;
        this.componentSource = componentSource;
        this.response = response;
        this.serviceAuthentication = serviceAuthentication;

        if (logger.isTraceEnabled()) {
            logger.trace("Construct");
        }
    }

    @Override
    public void handleComponentEvent(
            ComponentEventRequestParameters parameters,
            ComponentRequestHandler handler) throws IOException {
        
        if (logger.isTraceEnabled()) {
            logger.trace("handleComponentEvent");
        }

        Object[] context = prepareContext(
                                parameters.getActivePageName(),
                                parameters.getPageActivationContext());
        if (dispatchedToLoginPage(context)) {
            return;
        }

        handler.handleComponentEvent(parameters);

    }

    @Override
    public void handlePageRender(PageRenderRequestParameters parameters,
            ComponentRequestHandler handler) throws IOException {

        if (logger.isTraceEnabled()) {
            logger.trace("handlePageRender");
        }

        Object[] context = prepareContext(
                                parameters.getLogicalPageName(),
                                parameters.getActivationContext());
        if (dispatchedToLoginPage(context)) {
            return;
        }

        handler.handlePageRender(parameters);
    }

    /**
     * Prepare the context for redirect page.
     *
     * @param pageName the pageName to treate
     * @param activationContext the EventContext of this page
     * @return an array of Object for Context
     */
    protected Object[] prepareContext(String pageName,
                                      EventContext activationContext) {
        List<Object> list = new ArrayList<Object>();
        list.add(pageName);
        for (int i = 0; i < activationContext.getCount(); i++) {
            list.add(activationContext.get(Object.class, i));
        }
        return list.toArray(new Object[list.size()]);
    }

    private boolean dispatchedToLoginPage(Object... context)
            throws IOException {

        String pageName = (String)context[0];
        Component page = componentSource.getPage(pageName);

        if (logger.isTraceEnabled()) {
            logger.trace("Page name : " + pageName);
            logger.trace("Page class : " + page.getClass());
            logger.trace("RequiresLogin annotation : " +
                    page.getClass().isAnnotationPresent(RequiresAuthentication.class));
            logger.trace("User in session : " +
                    serviceAuthentication.existConnectedUser());
            logger.trace("Activation context : " + Arrays.toString(context));
        }

        if (!page.getClass().isAnnotationPresent(RequiresAuthentication.class)) {
            return false;
        }

        Class<?> redirectPage = Connexion.class;

        if (serviceAuthentication.existConnectedUser()) {
            ConnectedUser user = serviceAuthentication.getConnectedUser();

            // Check role, if not set, the user will be reset from session and redirect to login page.
            if (user.getRole() == null) {
                serviceAuthentication.setConnectedUser(null);
                return false;
            }

            if (logger.isTraceEnabled()) {
                logger.trace("User connected : " + user);
                logger.trace("User role : " + user.getRole());
                logger.trace("User allowed : " +
                        serviceAuthentication.isAllowed(page.getClass()));
            }

            if (serviceAuthentication.isAllowed(page.getClass())) {
                return false;
            }

            redirectPage = Unavailable.class;
        }

        Link link = pageRender.createPageRenderLinkWithContext(redirectPage,
                context);

        if (logger.isTraceEnabled()) {
            logger.trace("Redirection to " + redirectPage.getSimpleName() +
                    " page...");
        }

        response.sendRedirect(link);

        return true;
    }
}

