/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ConnectedUserImpl;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import org.apache.tapestry5.services.ApplicationStateManager;

public class ServiceAuthenticationImpl
implements ServiceAuthentication {
    private final ApplicationStateManager stateManager;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public boolean existConnectedUser() {
        return this.stateManager.exists(ConnectedUser.class);
    }

    public ConnectedUser getConnectedUser() {
        return (ConnectedUser)this.stateManager.getIfExists(ConnectedUser.class);
    }

    public void setConnectedUser(ConnectedUser user) {
        this.stateManager.set(ConnectedUser.class, (Object)user);
    }

    public boolean isAllowed(Class<?> page) {
        if (page.isAnnotationPresent(RequiresAuthentication.class) && this.existConnectedUser()) {
            RequiresAuthentication check = page.getAnnotation(RequiresAuthentication.class);
            ConnectedUser user = this.getConnectedUser();
            if (user.isReadOnly() && !check.readOnlyAllowed()) {
                return false;
            }
            for (UserRole role : check.value()) {
                if (!role.equals((Object)user.getRole())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public ConnectedUser getNewUserInstance() {
        return new ConnectedUserImpl();
    }
}

