/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: wao.js 503 2010-06-09 14:42:49Z fdesbois $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.3/wao-ui/src/main/webapp/js/wao.js $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
function openCommentWindow(window, commentPopupId, commentHiddenClass) {
    window.showCenter(true);
    var hidden = $$('.' + commentHiddenClass)[0];
    var value = hidden.getValue();
//    Tapestry.debug("unfinishedstate : " + unfinishedState);
//    if (unfinishedState) {
//        value += "\nRaison de l'échec :\n";
//    }
    $(commentPopupId).setValue(value);
}

function closeCommentWindow(window, commentPopupId, commentHiddenClass, unfinishedState, imgId, context) {
    var hidden = $$('.' + commentHiddenClass)[0];
    var oldValue = hidden.getValue();
    var newValue = $F(commentPopupId);
    var img = $(imgId);
    if ((unfinishedState && !newValue) || (unfinishedState && oldValue == newValue)) {
        img.setAttribute('src', context + '/img/comment-invalid-22px.png');
        img.setAttribute('title', 'Le commentaire est obligatoire pour un échec');
    } else if (oldValue != newValue) {
        img.setAttribute('src', context + '/img/comment-valid-22px.png');
        img.setAttribute('title', 'Le commentaire a bien été ajouté');
    } 
    hidden.setValue(newValue);
    window.close();
}

/**
 * Method used to refresh userRole select from a response. The response contains
 * data to create the select options :
 * - Array(option) response.select  : list of options to create
 * - String option.name             : name of the option (used as value)
 * - String option.label            : label to display for the option
 * This method uses elements :
 * - userRole : select input to use
 * - loginValid : img to display in case of login Ok (select is defined)
 * - loginInvalid : img to display in case of login Ko (select is undefined)
 */
function refreshUserRoles(response) {

    //Tapestry.debug('reponse.select = ' + response.select);

    if (response.select) {
        var content = '';

        for (i = 0; i < response.select.length; i++) {
            var option = response.select[i];

            //Tapestry.debug('option.name = ' + option.name);
            //Tapestry.debug('option.label = ' + option.label);

            content += '<option value="' + option.name + '"';
            // First option is selected
            if (i == 0) {
                content += ' selected="selected"';
            }
            content += '>' + option.label + '</option>\n\t';
        }
        // Update select userRole
        $('userRole').update(content);
        $('userRole').enable();
        // Display valid picture
        $('loginValid').toggleClassName('hidden');
        // Hide invalid picture if needed
        if (!$('loginInvalid').hasClassName('hidden')) {
            $('loginInvalid').toggleClassName('hidden');
        }
    } else {
        // Update select userRole (empty options)
        $('userRole').update('<option value=""></option>');
        $('userRole').disable();
        // Display invalid picture
        $('loginInvalid').toggleClassName('hidden');
        // Hide valid picture if needed
        if (!$('loginValid').hasClassName('hidden')) {
            $('loginValid').toggleClassName('hidden');
        }
    }
}
