/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.ProfessionImpl;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.SampleRowLog;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.WaoPropertyChangeListener;
import fr.ifremer.wao.ui.pages.SamplingPlan;
import fr.ifremer.wao.ui.services.WaoManager;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN}, readOnlyAllowed=false)
@IncludeStylesheet(value={"context:css/sampling.css"})
public class SampleRowForm {
    @Inject
    private Logger log;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceBoat serviceBoat;
    @SessionState
    @Property
    private WaoUser user;
    @Inject
    private PropertyAccess propertyAccess;
    private boolean edited;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Persist
    private GenericSelectModel<FishingZone> fishingZoneSelectModel;
    @Property
    private String fishingZoneId;
    @Property
    private FishingZone fishingZone;
    @Property
    private int indexFishingZone;
    @InjectComponent
    private Field fishingZoneSelect;
    @Inject
    private WaoManager manager;
    @Persist
    private SelectModel programSelectModel;
    @Property
    private String programName;
    @Property
    private String programId;
    private PeriodDates period;
    @Persist
    private List<SampleMonth> sampleMonths;
    @Property
    private int monthIndex;
    @Property
    private SampleMonth sampleMonth;
    @InjectComponent
    private Field programPeriodBegin;
    @InjectComponent
    private Field programPeriodEnd;
    @InjectComponent
    private Field program;
    private boolean periodChanged;
    private String sampleRowId;
    @Persist
    private SampleRow sampleRow;
    private BeanModel<SampleRow> sampleRowModel;
    @InjectComponent
    private Form sampleRowForm;
    @InjectComponent
    private Field updateComment;
    @Persist
    private SampleRowLog sampleRowLog;
    @Property
    private String immatriculations;
    @Property
    private String companyId;
    private List<Boat> boats;
    private GenericSelectModel<Company> companySelectModel;
    private boolean cancel;
    @Persist
    private WaoPropertyChangeListener propertyChange;

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.sampleRowId = (String)ec.get(String.class, 0);
        }
    }

    String onPassivate() {
        return this.sampleRowId;
    }

    void setupRender() throws WaoException {
        this.sampleRow = null;
        this.getSampleRow();
        this.sampleMonths = null;
        this.getSampleMonths();
        this.sampleRowLog = null;
        this.getSampleRowLog();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        this.programSelectModel = null;
        this.getProgramSelectModel();
        this.fishingZoneSelectModel = null;
        this.getFishingZoneSelectModel();
        this.companySelectModel = null;
        this.getCompanySelectModel();
        this.professionId = null;
        this.sampleRowForm.clearErrors();
        this.programId = !this.isCreateMode() ? this.getSampleRow().getProgramName() : null;
        Company company = this.getSampleRow().getCompany();
        if (company != null) {
            this.companyId = company.getTopiaId();
        }
        this.immatriculations = this.getSampleRow().getMainElligibleBoatsAsString();
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws WaoException {
        if (this.professionSelectModel == null) {
            List professions = this.serviceReferential.getProfessions();
            this.professionSelectModel = new GenericSelectModel(professions, Profession.class, "code", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public BeanModel<Profession> getProfessionModel() {
        return this.beanModelSource.createDisplayModel(Profession.class, this.resources.getMessages());
    }

    void onSelectedFromAddNewProfession() throws WaoException {
        ProfessionImpl profession = new ProfessionImpl();
        if (!StringUtils.isEmpty((String)this.professionId)) {
            Profession professionSelected = (Profession)this.getProfessionSelectModel().findObject(this.professionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add new profession from : " + professionSelected);
            }
            profession = this.serviceSampling.getNewProfession(professionSelected);
        }
        this.getSampleRow().setProfession((Profession)profession);
        this.edited = true;
    }

    public GenericSelectModel<FishingZone> getFishingZoneSelectModel() throws WaoException {
        if (this.fishingZoneSelectModel == null) {
            List zones = this.serviceReferential.getFishingZones();
            this.fishingZoneSelectModel = new GenericSelectModel(zones, FishingZone.class, "code", "topiaId", this.propertyAccess);
        }
        return this.fishingZoneSelectModel;
    }

    public List<FishingZone> getFishingZones() throws WaoException {
        return this.getSampleRow().getFishingZone();
    }

    void onSelectedFromAddFishingZone() throws WaoException {
        this.fishingZone = (FishingZone)this.getFishingZoneSelectModel().findObject(this.fishingZoneId);
        if (!this.getFishingZones().contains(this.fishingZone)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Add new fishingZone");
            }
            this.getFishingZones().add(this.fishingZone);
        }
        this.edited = true;
    }

    void onSelectedFromRemoveFishingZone(int index) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove fishingZone at position : " + index);
        }
        this.getFishingZones().remove(index);
        this.edited = true;
    }

    public SelectModel getProgramSelectModel() throws WaoException {
        if (this.programSelectModel == null) {
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String name : this.serviceSampling.getPrograms(null)) {
                options.add(new OptionModelImpl(name, (Object)name));
            }
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    public PeriodDates getPeriod() throws WaoException {
        if (this.period == null) {
            Date begin = this.getSampleRow().getPeriodBegin();
            Date end = this.getSampleRow().getPeriodEnd();
            this.period = new PeriodDates(begin, end);
        }
        return this.period;
    }

    public List<SampleMonth> getSampleMonths() throws WaoException {
        if (this.sampleMonths == null) {
            this.sampleMonths = new ArrayList();
            for (Date currMonth : this.getPeriod().getMonths()) {
                SampleMonth curr = this.getSampleRow().getSampleMonth(currMonth);
                if (curr != null) {
                    this.sampleMonths.add(curr);
                    continue;
                }
                if (!this.periodChanged) continue;
                if (curr == null) {
                    curr = this.serviceSampling.getNewSampleMonth(currMonth, this.getSampleRow());
                    curr.addPropertyChangeListener("expectedTidesValue", (PropertyChangeListener)this.propertyChange);
                }
                this.sampleMonths.add(curr);
            }
        }
        return this.sampleMonths;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public String getMonthStyle() {
        String style = " ";
        Date current = this.manager.getCurrentDate();
        if (this.sampleMonth.isCurrentMonth()) {
            style = style + "selected";
        } else if (current.after(this.sampleMonth.getPeriodDate())) {
            style = style + "even";
        }
        return style;
    }

    @Log
    void onSelectedFromRefreshMonths() throws WaoException {
        this.getSampleRow().setPeriod(this.period);
        this.periodChanged = true;
        this.sampleMonths = null;
        this.getSampleMonths();
        this.saveProgram();
    }

    protected void saveProgram() throws WaoException {
        if (StringUtils.isNotEmpty((String)this.programName)) {
            this.getSampleRow().setProgramName(this.programName);
            this.programId = null;
        } else if (StringUtils.isNotEmpty((String)this.programId)) {
            this.getSampleRow().setProgramName(this.programId);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Program : " + this.getSampleRow().getProgramName());
        }
    }

    @Log
    void onSelectedFromDeleteMonth(int index) throws WaoException {
        SampleMonth month = (SampleMonth)this.getSampleMonths().remove(index);
        month.removePropertyChangeListener("expectedTidesValue", (PropertyChangeListener)this.propertyChange);
        this.edited = true;
    }

    public SampleRow getSampleRow() throws WaoException {
        if (this.sampleRow == null) {
            if (!StringUtils.isEmpty((String)this.sampleRowId)) {
                this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowId);
                for (SampleMonth month : this.sampleRow.getSampleMonth()) {
                    month.addPropertyChangeListener("expectedTidesValue", (PropertyChangeListener)this.propertyChange);
                }
            } else {
                this.sampleRow = this.serviceSampling.getNewSampleRow();
            }
            this.propertyChange = new WaoPropertyChangeListener();
        }
        return this.sampleRow;
    }

    public SampleRowLog getSampleRowLog() throws WaoException {
        if (this.sampleRowLog == null) {
            this.sampleRowLog = this.getSampleRow().getNewSampleRowLog(this.user);
        }
        return this.sampleRowLog;
    }

    public BeanModel<SampleRow> getSampleRowModel() {
        if (this.sampleRowModel == null) {
            this.sampleRowModel = this.beanModelSource.createEditModel(SampleRow.class, this.resources.getMessages());
            this.sampleRowModel.add("company", null);
            this.sampleRowModel.add("boats", null);
            this.sampleRowModel.include(new String[]{"code", "company", "nbObservants", "averageTideTime", "boats", "comment"});
        }
        return this.sampleRowModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (this.companySelectModel == null) {
            List companies = this.serviceUser.getCompanies(true);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public boolean isCreateMode() throws WaoException {
        return StringUtils.isEmpty((String)this.getSampleRow().getTopiaId());
    }

    void onSelectedFromCancelSave() {
        this.cancel = true;
    }

    void onSelectedFromSaveData() throws WaoException {
        this.saveProgram();
    }

    @Log
    void onValidateFormFromSampleRowForm() throws WaoException {
        this.sampleRowForm.clearErrors();
        try {
            if (!this.cancel && !this.edited) {
                if (StringUtils.isEmpty((String)this.getSampleRow().getProgramName())) {
                    this.sampleRowForm.recordError(this.program, "Vous devez choisir un programme existant ou en cr\u00e9er un nouveau");
                }
                Date periodBegin = this.getSampleRow().getPeriodBegin();
                Date periodEnd = this.getSampleRow().getPeriodEnd();
                if (periodBegin == null) {
                    this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de d\u00e9but de programme vide");
                }
                if (periodEnd == null) {
                    this.sampleRowForm.recordError(this.programPeriodEnd, "Vous ne pouvez pas rafra\u00eechir les mois avec une date de fin de programme vide");
                }
                if (periodBegin != null && periodEnd != null) {
                    Date firstDate;
                    SampleMonth firstMonth = (SampleMonth)this.getSampleMonths().get(0);
                    if (firstMonth != null && periodBegin.after(firstDate = firstMonth.getPeriodDate()) && firstMonth.getRealTidesValue() != 0) {
                        this.sampleRowForm.recordError(this.programPeriodBegin, "Vous ne pouvez pas r\u00e9duire la p\u00e9riode du programme. Il existe des enregistrements de mar\u00e9es r\u00e9els.");
                    }
                    for (SampleMonth month : this.getSampleMonths()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("month : " + month.formatMonth() + " _ " + this.propertyChange.hasChanged(month.getTopiaId()));
                        }
                        if (!this.propertyChange.hasChanged(month.getTopiaId()) || month.getExpectedTidesValue() >= month.getRealTidesValue()) continue;
                        this.sampleRowForm.recordError("Il n'est pas possible de mettre moins de mar\u00e9es (" + month.getExpectedTidesValue() + ") " + "pour le mois " + this.getDateFormat().format(month.getPeriodDate()) + " qu'il y en a de r\u00e9els (" + month.getRealTidesValue() + ")");
                    }
                }
                if (!this.periodChanged) {
                    int nbZones;
                    Profession profession;
                    if (!this.isCreateMode() && StringUtils.isEmpty((String)this.sampleRowLog.getComment())) {
                        this.sampleRowForm.recordError(this.updateComment, "Un commentaire est obligatoire lors d'une modification de la ligne");
                    }
                    if (StringUtils.isEmpty((String)(profession = this.getSampleRow().getProfession()).getCodeDCF5())) {
                        this.sampleRowForm.recordError("Le m\u00e9tier doit obligatoirement avoir un Code DCF niveau 5");
                    }
                    if ((nbZones = this.getSampleRow().sizeFishingZone()) == 0) {
                        this.sampleRowForm.recordError(this.fishingZoneSelect, "Vous devez ajouter au moins une zone de p\u00eache \u00e0 la ligne");
                    }
                    this.boats = this.serviceBoat.getBoatsByImmatriculations(this.immatriculations);
                } else if (this.isCreateMode()) {
                    String rowCode = this.serviceSampling.getNewSampleRowCode(periodBegin);
                    this.getSampleRow().setCode(rowCode);
                }
            }
        }
        catch (WaoBusinessException eee) {
            this.sampleRowForm.recordError(eee.getMessage());
            this.log.error("BUSINESS ERROR : " + eee.getType() + " depuis " + eee.getServiceName() + " : " + eee.getMessage());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("SampleMonths : " + this.getSampleMonths());
        }
    }

    @Log
    Object onSuccessFromSampleRowForm() throws WaoException {
        if (this.cancel) {
            return this;
        }
        if (!this.edited && !this.periodChanged) {
            if (!this.getSampleRow().hasSampleMonthRealTideTime()) {
                Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
                this.getSampleRow().setCompany(company);
            }
            this.getSampleRow().setSampleMonth(this.getSampleMonths());
            this.serviceSampling.createUpdateSampleRow(this.sampleRow, this.boats, this.getSampleRowLog());
            return SamplingPlan.class;
        }
        this.professionId = null;
        return this.sampleRowForm;
    }

    @Log
    Object onFailureFromSampleRowForm() {
        return this.sampleRowForm;
    }
}

