/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.FeedBack;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

public class Connexion {
    @Inject
    private Logger logger;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private PageRenderLinkSource pageRender;
    @SessionState
    private WaoUser currentUser;
    @InjectComponent
    private FeedBack connexionFeedback;
    private String redirectPage;
    @Property
    private String login;
    @Property
    private String password;
    @Persist(value="flash")
    @Property
    private String email;

    void onActivate(String page) {
        this.redirectPage = page;
    }

    String onPassivate() {
        return this.redirectPage;
    }

    void onValidateFormFromConnexionForm() {
        block8: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Login : " + this.login);
                }
                if (this.login != null && this.password != null) {
                    this.currentUser = this.serviceUser.connect(this.login, this.password);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("User connected : " + this.currentUser.getFullName());
                    }
                }
            }
            catch (WaoBusinessException eee) {
                if (eee.getType().equals((Object)WaoBusinessException.Type.BAD_CONNECTION)) {
                    this.connexionFeedback.addError(new String[]{eee.getMessage()});
                    this.email = this.login;
                } else if (eee.getType().equals((Object)WaoBusinessException.Type.ILLEGAL_CONNECTION)) {
                    this.connexionFeedback.addInfo(eee.getMessage());
                }
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.error("WaoBusinessException : " + eee.getMessage(), (Throwable)eee);
            }
        }
    }

    @Log
    Object onSuccessFromConnexionForm() throws WaoException {
        if (this.hasConnexionErrors()) {
            return this;
        }
        if (this.redirectPage == null) {
            this.redirectPage = "index";
        }
        return this.pageRender.createPageRenderLink(this.redirectPage);
    }

    public boolean hasConnexionErrors() {
        return this.connexionFeedback.hasErrors();
    }

    void onSuccessFromForgetPassword() throws WaoException {
        try {
            this.serviceUser.forgetPassword(this.email);
            this.connexionFeedback.addInfo("Un email avec votre nouveau mot de passe vous a \u00e9t\u00e9 envoy\u00e9.");
        }
        catch (WaoBusinessException eee) {
            this.connexionFeedback.addError(new String[]{eee.getMessage()});
        }
    }
}

