/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import winstone.Cluster;
import winstone.Launcher;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.WebAppConfiguration;
import winstone.WebXmlParser;
import winstone.WinstoneException;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneSession;

public class HostConfiguration
implements Runnable {
    private static final long FLUSH_PERIOD = 60000L;
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_XML = "web.xml";
    private String hostname;
    private Map args;
    private Map webapps;
    private Cluster cluster;
    private ObjectPool objectPool;
    private ClassLoader commonLibCL;
    private File[] commonLibCLPaths;
    private Thread thread;

    public HostConfiguration(String hostname, Cluster cluster, ObjectPool objectPool, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args, String webappsDirName) throws IOException {
        this.hostname = hostname;
        this.args = args;
        this.webapps = new Hashtable();
        this.cluster = cluster;
        this.objectPool = objectPool;
        this.commonLibCL = commonLibCL;
        this.commonLibCLPaths = commonLibCLPaths;
        String warfile = (String)args.get("warfile");
        String webroot = (String)args.get("webroot");
        if (webappsDirName == null && (warfile != null || webroot != null)) {
            String prefix = (String)args.get("prefix");
            if (prefix == null) {
                prefix = "";
            }
            try {
                this.webapps.put(prefix, this.initWebApp(prefix, this.getWebRoot(webroot, warfile), "webapp"));
            }
            catch (IOException err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, (Throwable)err);
            }
        } else {
            this.initMultiWebappDir(webappsDirName);
        }
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.InitComplete", new String[]{this.webapps.size() + "", this.webapps.keySet() + ""});
        this.thread = new Thread((Runnable)this, "WinstoneHostConfigurationMgmt:" + this.hostname);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public WebAppConfiguration getWebAppByURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.equals("/") || uri.equals("")) {
            return (WebAppConfiguration)this.webapps.get("");
        }
        if (uri.startsWith("/")) {
            String decoded = WinstoneRequest.decodeURLToken(uri);
            String noLeadingSlash = decoded.substring(1);
            int slashPos = noLeadingSlash.indexOf("/");
            if (slashPos == -1) {
                return (WebAppConfiguration)this.webapps.get(decoded);
            }
            return (WebAppConfiguration)this.webapps.get(decoded.substring(0, slashPos + 1));
        }
        return null;
    }

    protected WebAppConfiguration initWebApp(String prefix, File webRoot, String contextName) throws IOException {
        File webXmlFile;
        Element webXMLParentNode = null;
        File webInfFolder = new File(webRoot, WEB_INF);
        if (webInfFolder.exists() && (webXmlFile = new File(webInfFolder, WEB_XML)).exists()) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.ParsingWebXml");
            Document webXMLDoc = new WebXmlParser(this.commonLibCL).parseStreamToXML(webXmlFile);
            if (webXMLDoc != null) {
                webXMLParentNode = webXMLDoc.getDocumentElement();
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.WebXmlParseComplete");
            } else {
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.WebXmlParseFailed");
            }
        }
        return new WebAppConfiguration(this, this.cluster, webRoot.getCanonicalPath(), prefix, this.objectPool, this.args, webXMLParentNode, this.commonLibCL, this.commonLibCLPaths, contextName);
    }

    public String getHostname() {
        return this.hostname;
    }

    private void destroyWebApp(String prefix) {
        WebAppConfiguration webAppConfig = (WebAppConfiguration)this.webapps.get(prefix);
        if (webAppConfig != null) {
            webAppConfig.destroy();
            this.webapps.remove(prefix);
        }
    }

    public void destroy() {
        HashSet prefixes = new HashSet(this.webapps.keySet());
        Iterator i = prefixes.iterator();
        while (i.hasNext()) {
            this.destroyWebApp((String)i.next());
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void invalidateExpiredSessions() {
        HashSet webapps = new HashSet(this.webapps.values());
        Iterator i = webapps.iterator();
        while (i.hasNext()) {
            ((WebAppConfiguration)i.next()).invalidateExpiredSessions();
        }
    }

    public void run() {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                Thread.sleep(60000L);
                this.invalidateExpiredSessions();
            }
            catch (InterruptedException err) {
                interrupted = true;
            }
        }
        this.thread = null;
    }

    public void reloadWebApp(String prefix) throws IOException {
        WebAppConfiguration webAppConfig = (WebAppConfiguration)this.webapps.get(prefix);
        if (webAppConfig != null) {
            String webRoot = webAppConfig.getWebroot();
            String contextName = webAppConfig.getContextName();
            this.destroyWebApp(prefix);
            try {
                this.webapps.put(prefix, this.initWebApp(prefix, new File(webRoot), contextName));
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, err);
            }
        } else {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.PrefixUnknown", prefix));
        }
    }

    protected File getWebRoot(String requestedWebroot, String warfileName) throws IOException {
        if (warfileName != null) {
            File timestampFile;
            Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.BeginningWarExtraction");
            File warfileRef = new File(warfileName);
            if (!warfileRef.exists() || !warfileRef.isFile()) {
                throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WarFileInvalid", warfileName));
            }
            File unzippedDir = null;
            if (requestedWebroot != null) {
                unzippedDir = new File(requestedWebroot);
            } else {
                File tempFile = File.createTempFile("dummy", "dummy");
                String userName = System.getProperty("user.name");
                unzippedDir = new File(tempFile.getParent(), (userName != null ? WinstoneResourceBundle.globalReplace(userName, new String[][]{{"/", ""}, {"\\", ""}, {",", ""}}) + "/" : "") + "winstone/" + warfileRef.getName());
                tempFile.delete();
            }
            if (unzippedDir.exists()) {
                if (!unzippedDir.isDirectory()) {
                    throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebRootNotDirectory", unzippedDir.getPath()));
                }
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.WebRootExists", unzippedDir.getCanonicalPath());
            }
            if ((timestampFile = new File(unzippedDir, ".timestamp")).exists() && Math.abs(timestampFile.lastModified() - warfileRef.lastModified()) <= 1000L) {
                return unzippedDir;
            }
            this.deleteRecursive(unzippedDir);
            unzippedDir.mkdirs();
            byte[] buffer = new byte[8192];
            JarFile warArchive = new JarFile(warfileRef);
            Enumeration<JarEntry> e = warArchive.entries();
            while (e.hasMoreElements()) {
                String elemName;
                File outFile;
                JarEntry element = e.nextElement();
                if (element.isDirectory() || (outFile = new File(unzippedDir, elemName = element.getName())).exists() && outFile.lastModified() > warfileRef.lastModified()) continue;
                outFile.getParentFile().mkdirs();
                InputStream inContent = warArchive.getInputStream(element);
                FileOutputStream outStream = new FileOutputStream(outFile);
                int readBytes = inContent.read(buffer);
                while (readBytes != -1) {
                    ((OutputStream)outStream).write(buffer, 0, readBytes);
                    readBytes = inContent.read(buffer);
                }
                inContent.close();
                ((OutputStream)outStream).close();
            }
            new FileOutputStream(timestampFile).close();
            timestampFile.setLastModified(warfileRef.lastModified());
            return unzippedDir;
        }
        return new File(requestedWebroot);
    }

    private void deleteRecursive(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                this.deleteRecursive(child);
            }
        }
        dir.delete();
    }

    protected void initMultiWebappDir(String webappsDirName) throws IOException {
        File webappsDir;
        if (webappsDirName == null) {
            webappsDirName = "webapps";
        }
        if (!(webappsDir = new File(webappsDirName)).exists()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebAppDirNotFound", webappsDirName));
        }
        if (!webappsDir.isDirectory()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebAppDirIsNotDirectory", webappsDirName));
        }
        File[] children = webappsDir.listFiles();
        for (int n = 0; n < children.length; ++n) {
            String prefix;
            String childName = children[n].getName();
            if (children[n].isDirectory()) {
                File matchingWarFile = new File(webappsDir, children[n].getName() + ".war");
                if (matchingWarFile.exists() && matchingWarFile.isFile()) {
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.SkippingWarfileDir", childName);
                    continue;
                }
                String string = prefix = childName.equalsIgnoreCase("ROOT") ? "" : "/" + childName;
                if (this.webapps.containsKey(prefix)) continue;
                try {
                    WebAppConfiguration webAppConfig = this.initWebApp(prefix, children[n], childName);
                    this.webapps.put(webAppConfig.getContextPath(), webAppConfig);
                    Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.DeployingWebapp", childName);
                }
                catch (Throwable err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, err);
                }
                continue;
            }
            if (!childName.endsWith(".war")) continue;
            String outputName = childName.substring(0, childName.lastIndexOf(".war"));
            String string = prefix = outputName.equalsIgnoreCase("ROOT") ? "" : "/" + outputName;
            if (this.webapps.containsKey(prefix)) continue;
            File outputDir = new File(webappsDir, outputName);
            outputDir.mkdirs();
            try {
                WebAppConfiguration webAppConfig = this.initWebApp(prefix, this.getWebRoot(new File(webappsDir, outputName).getCanonicalPath(), children[n].getCanonicalPath()), outputName);
                this.webapps.put(webAppConfig.getContextPath(), webAppConfig);
                Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.DeployingWebapp", childName);
                continue;
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, err);
            }
        }
    }

    public WebAppConfiguration getWebAppBySessionKey(String sessionKey) {
        ArrayList allwebapps = new ArrayList(this.webapps.values());
        Iterator i = allwebapps.iterator();
        while (i.hasNext()) {
            WebAppConfiguration webapp = (WebAppConfiguration)i.next();
            WinstoneSession session = webapp.getSessionById(sessionKey, false);
            if (session == null) continue;
            return webapp;
        }
        return null;
    }
}

