/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.GenericSelectModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

public abstract class AbstractFilteredPage {
    @Inject
    private Logger log;
    @SessionState
    private WaoUser user;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceUser serviceUser;
    @Persist
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    @Property
    private String sampleRowId;
    @Persist
    private SelectModel facadeSelectModel;
    @Persist
    private SelectModel sectorSelectModel;
    @Persist
    private GenericSelectModel<Company> companySelectModel;
    @Property
    private String companyId;
    @Persist
    private GenericSelectModel<WaoUser> observerSelectModel;
    @Property
    private String observerId;
    @Persist
    private SelectModel programSelectModel;
    @Persist
    private boolean observerSelect;
    @Persist
    private boolean programSelect;
    private boolean edited;

    protected void initSelectFilters(boolean companySelect, boolean observerSelect, boolean programSelect) throws WaoException {
        this.observerSelect = observerSelect;
        this.programSelect = programSelect;
        if (this.getFilter().getSampleRow() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("SampleRow filtered : " + this.getFilter().getSampleRow());
            }
            this.sampleRowId = this.getFilter().getSampleRow().getTopiaId();
        }
        if (this.user.getAdmin() && companySelect) {
            this.resetCompanySelect();
            if (this.getFilter().getCompany() != null) {
                this.companyId = this.getFilter().getCompany().getTopiaId();
            }
        } else if (!this.user.getAdmin()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Company filtered : " + this.user.getCompany());
            }
            this.getFilter().setCompany(this.user.getCompany());
        }
        if (observerSelect) {
            this.observerSelectModel = null;
            this.getObserverSelectModel();
            if (this.getFilter().getObserver() != null) {
                this.observerId = this.getFilter().getObserver().getTopiaId();
            }
        }
        if (programSelect) {
            this.programSelectModel = null;
            this.getProgramSelectModel();
        }
        this.resetFacadeSelect();
        this.resetSectorSelect();
        this.resetSampleRowSelect();
    }

    protected void resetCompanySelect() throws WaoException {
        this.companySelectModel = null;
        this.getCompanySelectModel();
    }

    protected void resetFacadeSelect() throws WaoException {
        this.facadeSelectModel = null;
        this.getFacadeSelectModel();
    }

    protected void resetSectorSelect() throws WaoException {
        this.sectorSelectModel = null;
        this.getSectorSelectModel();
    }

    protected void resetSampleRowSelect() throws WaoException {
        this.sampleRowSelectModel = null;
        this.getSampleRowSelectModel();
    }

    public SelectModel getFacadeSelectModel() throws WaoException {
        if (this.facadeSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getFacades]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String facadeName : this.serviceReferential.getFacades((SamplingFilter)this.getFilter())) {
                options.add(new OptionModelImpl(facadeName, (Object)facadeName));
            }
            this.facadeSelectModel = new SelectModelImpl(null, options);
        }
        return this.facadeSelectModel;
    }

    public SelectModel getSectorSelectModel() throws WaoException {
        if (this.sectorSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSectors]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String sectorName : this.serviceReferential.getSectors((SamplingFilter)this.getFilter())) {
                options.add(new OptionModelImpl(sectorName, (Object)sectorName));
            }
            this.sectorSelectModel = new SelectModelImpl(null, options);
        }
        return this.sectorSelectModel;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() throws WaoException {
        if (this.sampleRowSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRowsByFilter]");
            }
            SampleRow rowFiltered = this.getFilter().getSampleRow();
            this.getFilter().setSampleRow(null);
            List sampleRows = this.serviceSampling.getSampleRowsByFilter((SamplingFilter)this.getFilter());
            this.getFilter().setSampleRow(rowFiltered);
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "topiaId", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (this.companySelectModel == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List companies = this.serviceUser.getCompanies(this.isAvailableDataForFiltersOnly());
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public GenericSelectModel<WaoUser> getObserverSelectModel() throws WaoException {
        if (this.observerSelectModel == null) {
            List observers = new ArrayList();
            if (this.getFilter().getCompany() != null) {
                observers = this.getFilter().getCompany().getWaoUser();
            } else if (this.user.getAdmin()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("BUSINESS REQUEST [getObservers]");
                }
                observers = this.serviceUser.getObservers(this.isAvailableDataForFiltersOnly());
            }
            this.observerSelectModel = new GenericSelectModel(observers, WaoUser.class, "fullName", "topiaId", this.propertyAccess);
        }
        return this.observerSelectModel;
    }

    public SelectModel getProgramSelectModel() throws WaoException {
        if (this.programSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getPrograms]");
            }
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String programName : this.serviceSampling.getPrograms(this.getFilter().getCompany())) {
                options.add(new OptionModelImpl(programName, (Object)programName));
            }
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    protected abstract BoatFilter getFilter() throws WaoException;

    protected abstract boolean isAvailableDataForFiltersOnly();

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        if (this.log.isInfoEnabled()) {
            this.log.info("BUSINESS REQUEST [getBoatNamesStartWith]");
        }
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[0]);
    }

    public void onSelectedFromSearch() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("REFRESH FILTERS DATA");
        }
        SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.sampleRowId);
        this.getFilter().setSampleRow(row);
        if (this.user.getAdmin()) {
            Company company = (Company)this.getCompanySelectModel().findObject(this.companyId);
            this.getFilter().setCompany(company);
        } else {
            this.getFilter().setCompany(this.user.getCompany());
        }
        if (this.observerSelect) {
            WaoUser observer = (WaoUser)this.getObserverSelectModel().findObject(this.observerId);
            this.getFilter().setObserver(observer);
        }
    }

    public void onSelectedFromRefreshByCompany() throws WaoException {
        this.getFilter().setProgramName(null);
        this.onSelectedFromRefreshByProgram();
        if (this.observerSelect) {
            this.getFilter().setObserver(null);
            this.observerSelectModel = null;
            this.getObserverSelectModel();
        }
        if (this.programSelect) {
            this.programSelectModel = null;
            this.getProgramSelectModel();
        }
        this.edited = true;
    }

    public void onSelectedFromRefreshByProgram() throws WaoException {
        this.getFilter().setFacadeName(null);
        this.onSelectedFromRefreshByFacade();
        this.resetFacadeSelect();
    }

    public void onSelectedFromRefreshByFacade() throws WaoException {
        this.getFilter().setSectorName(null);
        this.onSelectedFromRefreshBySector();
        this.resetSectorSelect();
    }

    public void onSelectedFromRefreshBySector() throws WaoException {
        this.onSelectedFromSearch();
        this.getFilter().setSampleRow(null);
        this.resetSampleRowSelect();
        this.edited = true;
    }

    protected boolean isEdited() {
        return this.edited;
    }
}

