/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FixesBatchRankOrder {
    protected boolean commit;

    public static void main(String ... args) throws Exception {
        if (args.length <= 0 || "-nocommit".equals(args[0]) && args.length <= 1) {
            System.err.println("usage: FixesBatchRankOrder -nocommit <db file path> [login] [password]");
        } else {
            int i = 0;
            boolean commit = true;
            if ("-nocommit".equals(args[0])) {
                commit = false;
            }
            int n = ++i;
            String dbPath = args[n];
            String login = args.length > ++i ? args[i++] : "SA";
            String password = args.length > i ? args[i++] : "";
            new FixesBatchRankOrder(commit).doAction(dbPath, login, password);
        }
    }

    public FixesBatchRankOrder() {
        this(true);
    }

    public FixesBatchRankOrder(boolean commit) {
        this.commit = commit;
    }

    public void doAction(String dbPath, String login, String password) throws Exception {
        System.out.println("FixesRankOrder for db: " + dbPath);
        Class.forName("org.hsqldb.jdbcDriver");
        try (Connection c = DriverManager.getConnection(String.format("jdbc:hsqldb:file:%s;ifexists=true;shutdown=true", dbPath), login, password);){
            this.doAction(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Connection c) throws Exception {
        boolean autoCommit = c.getAutoCommit();
        try {
            c.setAutoCommit(false);
            PreparedStatement catchWithError = c.prepareStatement("SELECT b1.parent_batch_fk as pid, count(b1.id) as conflict FROM BATCH b1, BATCH b2 WHERE b1.parent_batch_fk = b2.parent_batch_fk and b1.raNK_ORDER=b2.rank_order and b1.id != b2.id group by b1.parent_batch_fk ORDER BY b1.parent_batch_fk");
            ResultSet rs = catchWithError.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("pid");
                int conflict = rs.getInt("conflict");
                this.fixesRankOrder(c, id, conflict);
            }
            if (this.commit) {
                c.commit();
                System.out.println("Modification commited");
            } else {
                c.rollback();
                System.out.println("Modification reverted");
            }
        }
        finally {
            c.setAutoCommit(autoCommit);
        }
    }

    protected int fixesRankOrder(Connection c, int id, int conflict) throws Exception {
        System.out.println(String.format("FixesRankOrder catch id: %s with %s conflicts ", id, conflict));
        String query = "update batch set rank_order = (select count(id) from batch b2 where batch.parent_batch_fk = b2.parent_batch_fk and convert(concat(concat(b2.rank_order, '.'), b2.id), DECIMAL)  < convert(concat(concat(batch.rank_order, '.'), batch.id), DECIMAL) ) +1where PARENT_BATCH_FK = ?";
        PreparedStatement update = c.prepareStatement(query);
        update.setInt(1, id);
        int result = update.executeUpdate();
        System.out.println(String.format("..... %s children reordered", result));
        return result;
    }
}

