/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.ImmutableMap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportResult;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class BenthosBatchUISupportImpl
extends SpeciesOrBenthosBatchUISupport {
    protected static final Map<String, String> CATCHES_UI_MODEL_PROPERTIES_MAPPING = ImmutableMap.builder().put((Object)"benthosTotalComputedWeight", (Object)"totalComputedWeight").put((Object)"benthosTotalSortedWeight", (Object)"totalSortedWeight").put((Object)"benthosTotalUnsortedComputedWeight", (Object)"totalUnsortedComputedWeight").put((Object)"benthosTotalSampleSortedComputedWeight", (Object)"totalSampleSortedComputedWeight").put((Object)"benthosTotalInertWeight", (Object)"totalInertWeight").put((Object)"benthosTotalLivingNotItemizedWeight", (Object)"totalLivingNotItemizedWeight").build();

    public BenthosBatchUISupportImpl(TuttiUIContext context, EditCatchesUIModel catchesUIModel, WeightUnit weightUnit) {
        super(context, catchesUIModel, CATCHES_UI_MODEL_PROPERTIES_MAPPING, weightUnit);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(Integer batchId) {
        return this.getPersistenceService().getRootBenthosBatch(batchId, true);
    }

    @Override
    public String getTitle() {
        return I18n.n((String)"tutti.label.tab.benthos", (Object[])new Object[0]);
    }

    @Override
    public boolean canPupitriImport() {
        return false;
    }

    @Override
    public boolean canPsionImport() {
        return false;
    }

    @Override
    public boolean canBigfinImport() {
        return false;
    }

    @Override
    public Float getTotalComputedWeight() {
        return this.catchesUIModel.getBenthosTotalComputedWeight();
    }

    @Override
    public void setTotalComputedWeight(Float totalComputedWeight) {
        this.catchesUIModel.setBenthosTotalComputedWeight(totalComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalSortedComputedOrNotWeight() {
        return this.catchesUIModel.getBenthosTotalSortedComputedOrNotWeight();
    }

    @Override
    public Float getTotalSortedWeight() {
        return this.catchesUIModel.getBenthosTotalSortedWeight();
    }

    @Override
    public void setTotalSortedWeight(Float totalSortedWeight) {
        this.catchesUIModel.setBenthosTotalSortedWeight(totalSortedWeight);
    }

    @Override
    public Float getTotalSortedComputedWeight() {
        return this.catchesUIModel.getBenthosTotalSortedComputedWeight();
    }

    @Override
    public void setTotalSortedComputedWeight(Float totalSortedComputedWeight) {
        this.catchesUIModel.setBenthosTotalSortedComputedWeight(totalSortedComputedWeight);
    }

    @Override
    public Float getTotalUnsortedComputedWeight() {
        return this.catchesUIModel.getBenthosTotalUnsortedComputedWeight();
    }

    @Override
    public void setTotalUnsortedComputedWeight(Float totalUnsortedComputedWeight) {
        this.catchesUIModel.setBenthosTotalUnsortedComputedWeight(totalUnsortedComputedWeight);
    }

    @Override
    public Float getTotalSampleSortedComputedWeight() {
        return this.catchesUIModel.getBenthosTotalSampleSortedComputedWeight();
    }

    @Override
    public void setTotalSampleSortedComputedWeight(Float totalSampleSortedComputedWeight) {
        this.catchesUIModel.setBenthosTotalSampleSortedComputedWeight(totalSampleSortedComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalInertComputedOrNotWeight() {
        return this.catchesUIModel.getBenthosTotalInertComputedOrNotWeight();
    }

    @Override
    public Float getTotalInertWeight() {
        return this.catchesUIModel.getBenthosTotalInertWeight();
    }

    @Override
    public void setTotalInertWeight(Float totalInertWeight) {
        this.catchesUIModel.setBenthosTotalInertWeight(totalInertWeight);
    }

    @Override
    public Float getTotalInertComputedWeight() {
        return this.catchesUIModel.getBenthosTotalInertComputedWeight();
    }

    @Override
    public void setTotalInertComputedWeight(Float totalInertComputedWeight) {
        this.catchesUIModel.setBenthosTotalInertComputedWeight(totalInertComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalLivingNotItemizedComputedOrNotWeight() {
        return this.catchesUIModel.getBenthosTotalLivingNotItemizedComputedOrNotWeight();
    }

    @Override
    public Float getTotalLivingNotItemizedWeight() {
        return this.catchesUIModel.getBenthosTotalLivingNotItemizedWeight();
    }

    @Override
    public void setTotalLivingNotItemizedWeight(Float totalLivingNotItemizedWeight) {
        this.catchesUIModel.setBenthosTotalLivingNotItemizedWeight(totalLivingNotItemizedWeight);
    }

    @Override
    public Float getTotalLivingNotItemizedComputedWeight() {
        return this.catchesUIModel.getBenthosTotalLivingNotItemizedComputedWeight();
    }

    @Override
    public void setTotalLivingNotItemizedComputedWeight(Float totalLivingNotItemizedComputedWeight) {
        this.catchesUIModel.setBenthosTotalLivingNotItemizedComputedWeight(totalLivingNotItemizedComputedWeight);
    }

    @Override
    public Integer getDistinctSortedSpeciesCount() {
        return this.catchesUIModel.getBenthosDistinctSortedSpeciesCount();
    }

    @Override
    public void setDistinctSortedSpeciesCount(Integer distinctSortedSpeciesCount) {
        this.catchesUIModel.setBenthosDistinctSortedSpeciesCount(distinctSortedSpeciesCount);
    }

    @Override
    public Integer getDistinctUnsortedSpeciesCount() {
        return this.catchesUIModel.getBenthosDistinctUnsortedSpeciesCount();
    }

    @Override
    public void setDistinctUnsortedSpeciesCount(Integer distinctUnsortedSpeciesCount) {
        this.catchesUIModel.setBenthosDistinctUnsortedSpeciesCount(distinctUnsortedSpeciesCount);
    }

    @Override
    public Map<String, Object> importMultiPost(File file, FishingOperation operation, boolean importFrequencies, boolean importIndivudalObservations) {
        return this.context.getMultiPostImportService().importBenthos(file, operation, importFrequencies, importIndivudalObservations);
    }

    @Override
    public MultiPostImportResult importMultiPost(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndivudalObservations) {
        return this.context.getMultiPostImportService().importBenthosBatch(file, operation, speciesBatch, importFrequencies, importIndivudalObservations);
    }

    @Override
    public void exportMultiPost(File file, FishingOperation operation, boolean importFrequencies, boolean importIndivudalObservations) {
        this.context.getMultiPostExportService().exportBenthos(file, operation, importFrequencies, importIndivudalObservations);
    }

    @Override
    public void exportMultiPost(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndivudalObservations) {
        this.context.getMultiPostExportService().exportBatch(file, operation, speciesBatch, importFrequencies, importIndivudalObservations);
    }

    @Override
    public SpeciesBatch createBatch(SpeciesBatch speciesBatch, Integer parentBatchId) {
        return this.getPersistenceService().createBenthosBatch(speciesBatch, parentBatchId, true);
    }

    @Override
    public SpeciesBatch saveBatch(SpeciesBatch speciesBatch) {
        return this.getPersistenceService().saveBenthosBatch(speciesBatch);
    }

    @Override
    public List<SpeciesBatchFrequency> saveBatchFrequencies(Integer speciesBatchId, List<SpeciesBatchFrequency> frequency) {
        return this.getPersistenceService().saveBenthosBatchFrequency(speciesBatchId, frequency);
    }

    @Override
    public List<Species> getReferentSpeciesWithSurveyCode(boolean restrictToProtocol) {
        return this.context.getDataContext().getReferentBenthosWithSurveyCode(restrictToProtocol);
    }

    @Override
    public List<Species> getReferentOtherSpeciesWithSurveyCode(boolean restrictToProtocol) {
        return this.context.getDataContext().getReferentSpeciesWithSurveyCode(restrictToProtocol);
    }

    @Override
    public List<SpeciesProtocol> getSpeciesFromProtocol() {
        TuttiProtocol p = this.context.getDataContext().getProtocol();
        List<SpeciesProtocol> result = p != null ? p.getBenthos() : Collections.EMPTY_LIST;
        return result;
    }

    @Override
    public void deleteSpeciesSubBatch(Integer speciesBatchId) {
        this.getPersistenceService().deleteBenthosSubBatch(speciesBatchId);
    }

    @Override
    public void deleteSpeciesBatch(Integer speciesBatchId) {
        this.getPersistenceService().deleteBenthosBatch(speciesBatchId);
    }
}

