/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri.report;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.pupitri.PupitriImportResult;
import fr.ifremer.tutti.service.pupitri.report.PupitriImportReportRow;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.util.Numbers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class PupitriImportReportModel {
    private final FishingOperation operation;
    private final PupitriImportResult importResult;
    private final List<PupitriImportReportRow> rows;

    public PupitriImportReportModel(FishingOperation operation, PupitriImportResult importResult) {
        this.operation = operation;
        this.importResult = importResult;
        this.rows = new ArrayList<PupitriImportReportRow>();
    }

    public String getStationNumber() {
        return this.operation.getStationNumber();
    }

    public Integer getFishingOperationNumber() {
        return this.operation.getFishingOperationNumber();
    }

    public String getMultirigAggregation() {
        return this.operation.getMultirigAggregation();
    }

    public Date getGearShootingStartDate() {
        return this.operation.getGearShootingStartDate();
    }

    public Date getGearShootingEndDate() {
        return this.operation.getGearShootingEndDate();
    }

    public Float getTrunkSortedWeight() {
        Float sortedWeight = this.importResult.getSortedWeight();
        return sortedWeight == null ? null : WeightUnit.KG.round(sortedWeight);
    }

    public Float getTrunkRejectedWeight() {
        Float rejectedWeight = this.importResult.getRejectedWeight();
        return rejectedWeight == null ? null : WeightUnit.KG.round(rejectedWeight);
    }

    public Float getTrunkTotalWeight() {
        float trunkSortedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.importResult.getSortedWeight(), (Number)Float.valueOf(0.0f))).floatValue();
        float trunkRejectedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.importResult.getRejectedWeight(), (Number)Float.valueOf(0.0f))).floatValue();
        return WeightUnit.KG.round(Float.valueOf(trunkSortedWeight + trunkRejectedWeight));
    }

    public Float getCarrouselSortedWeight() {
        Float carrouselSortedWeight = this.importResult.getCarrouselSortedWeight();
        return carrouselSortedWeight == null ? null : WeightUnit.KG.round(carrouselSortedWeight);
    }

    public Float getCarrouselUnsortedWeight() {
        Float carrouselUnsortedWeight = this.importResult.getCarrouselUnsortedWeight();
        return carrouselUnsortedWeight == null ? null : WeightUnit.KG.round(carrouselUnsortedWeight);
    }

    public Float getCarrouselTotalWeight() {
        float trunkSortedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.importResult.getCarrouselSortedWeight(), (Number)Float.valueOf(0.0f))).floatValue();
        float trunkRejectedWeight = ((Float)Numbers.getValueOrComputedValue((Number)this.importResult.getCarrouselUnsortedWeight(), (Number)Float.valueOf(0.0f))).floatValue();
        return WeightUnit.KG.round(Float.valueOf(trunkSortedWeight + trunkRejectedWeight));
    }

    public Set<String> getNotImportedSpeciesIds() {
        return this.importResult.getNotImportedSpeciesIds();
    }

    public List<PupitriImportReportRow> getRows() {
        return this.rows;
    }

    public void addRow(PupitriImportReportRow aCatch) {
        this.rows.add(aCatch);
    }

    public void sortRows() {
        Ordering o1 = Ordering.natural().reverse().onResultOf((Function)new Function<PupitriImportReportRow, Boolean>(){

            public Boolean apply(PupitriImportReportRow input) {
                return input.isSorted();
            }
        });
        Ordering o2 = Ordering.natural().onResultOf((Function)new Function<PupitriImportReportRow, String>(){

            public String apply(PupitriImportReportRow input) {
                return input.getSpeciesCode();
            }
        });
        Ordering ordering = Ordering.compound((Iterable)ImmutableSet.of((Object)o1, (Object)o2));
        Collections.sort(this.rows, ordering);
    }
}

