/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListBandContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCView;

public class ReportContent
implements IReportContent {
    private CSSEngine cssEngine;
    private Report report;
    private List<ExecutionContext.ElementExceptionInfo> errors = new ArrayList<ExecutionContext.ElementExceptionInfo>();
    private ITreeNode tocTree;
    private IContent root;
    private long totalPage;
    protected String acl;
    private IReportContext reportContext;
    private ExecutionContext executionContext;
    private Map<String, Object> userProperties;
    private Map<String, Object> extProperties;
    private String title;
    static final short FIELD_ACL = 0;
    static final short FIELD_USER_PROPERTIES = 1;
    static final short FIELD_EXTENSIONS = 2;

    public ReportContent(Report report) {
        this.cssEngine = report.getCSSEngine();
        this.report = report;
        this.root = this.createContainerContent();
        this.root.setStyleClass(report.getRootStyleName());
    }

    public ReportContent() {
        this.cssEngine = new BIRTCSSEngine();
    }

    @Override
    public Report getDesign() {
        return this.report;
    }

    @Override
    public IStyle findStyle(String styleClass) {
        return this.report == null ? null : this.report.findStyle(styleClass);
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    @Override
    public IContent getRoot() {
        return this.root;
    }

    @Override
    public IPageContent getPageContent(long pageNumber) {
        return null;
    }

    @Override
    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    @Override
    public IContent getContent(InstanceID id) {
        return null;
    }

    @Override
    public IHyperlinkAction createActionContent() {
        return new ActionContent();
    }

    @Override
    public IStyle createStyle() {
        return new StyleDeclaration(this.cssEngine);
    }

    @Override
    public ICellContent createCellContent() {
        return new CellContent(this);
    }

    @Override
    public IContainerContent createContainerContent() {
        return new ContainerContent(this);
    }

    @Override
    public IPageContent createPageContent() {
        return new PageContent(this);
    }

    @Override
    public IRowContent createRowContent() {
        return new RowContent(this);
    }

    @Override
    public IListContent createListContent() {
        return new ListContent(this);
    }

    @Override
    public IListGroupContent createListGroupContent() {
        return new ListGroupContent(this);
    }

    @Override
    public IListBandContent createListBandContent() {
        return new ListBandContent(this);
    }

    @Override
    public ITableContent createTableContent() {
        return new TableContent(this);
    }

    @Override
    public ITableGroupContent createTableGroupContent() {
        return new TableGroupContent(this);
    }

    @Override
    public ITableBandContent createTableBandContent() {
        return new TableBandContent(this);
    }

    @Override
    public ITextContent createTextContent() {
        return new TextContent(this);
    }

    @Override
    public ITextContent createTextContent(IContent content) {
        return new TextContent(content);
    }

    @Override
    public IDataContent createDataContent() {
        return new DataContent(this);
    }

    @Override
    public IDataContent createDataContent(IContent content) {
        return new DataContent(content);
    }

    @Override
    public ILabelContent createLabelContent() {
        return new LabelContent(this);
    }

    @Override
    public ILabelContent createLabelContent(IContent content) {
        return new LabelContent(content);
    }

    @Override
    public IAutoTextContent createAutoTextContent() {
        return new AutoTextContent(this);
    }

    @Override
    public IForeignContent createForeignContent() {
        return new ForeignContent(this);
    }

    public IForeignContent createForeignContent(IContent content) {
        return new ForeignContent(content);
    }

    @Override
    public IImageContent createImageContent() {
        return new ImageContent(this);
    }

    @Override
    public IImageContent createImageContent(IContent content) {
        return new ImageContent(content);
    }

    public IImageContent createObjectContent() {
        return new ObjectContent(this);
    }

    @Override
    public List<ExecutionContext.ElementExceptionInfo> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ExecutionContext.ElementExceptionInfo> errors) {
        this.errors = errors != null ? errors : new ArrayList<ExecutionContext.ElementExceptionInfo>();
    }

    @Override
    public ITOCTree getTOCTree(String format, ULocale locale) {
        if (this.tocTree == null) {
            return null;
        }
        return new TOCView(this.tocTree, this.report.getReportDesign(), locale, TimeZone.getDefault());
    }

    public void setTOCTree(ITreeNode tocTree) {
        this.tocTree = tocTree;
    }

    @Override
    public TOCNode getTOC() {
        return this.getTOCTree("viewer", ULocale.getDefault()).getRoot();
    }

    @Override
    public String getACL() {
        return this.acl;
    }

    @Override
    public void setACL(String acl) {
        this.acl = acl;
    }

    @Override
    public IReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(IReportContext context) {
        this.reportContext = context;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Map<String, Object> properties) {
        this.userProperties = properties;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extProperties;
    }

    @Override
    public void setExtensions(Map<String, Object> properties) {
        this.extProperties = properties;
    }

    @Override
    public void readContent(DataInputStream in, ClassLoader loader) throws IOException {
        while (in.available() > 0) {
            short filedId = IOUtil.readShort(in);
            this.readField(filedId, in, loader);
        }
    }

    private void readField(int fieldId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (fieldId) {
            case 0: {
                this.acl = IOUtil.readString(in);
                break;
            }
            case 1: {
                this.userProperties = IOUtil.readMap(in);
                break;
            }
            case 2: {
                this.extProperties = IOUtil.readMap(in);
                break;
            }
            default: {
                throw new IOException("Error.UnknownFieldID" + fieldId);
            }
        }
    }

    @Override
    public void writeContent(DataOutputStream out) throws IOException {
        if (this.acl != null) {
            IOUtil.writeShort(out, (short)0);
            IOUtil.writeObject(out, this.acl);
        }
        if (this.userProperties != null && this.userProperties.size() > 0) {
            IOUtil.writeShort(out, (short)1);
            IOUtil.writeMap(out, this.userProperties);
        }
        if (this.extProperties != null && !this.extProperties.isEmpty()) {
            IOUtil.writeShort(out, (short)2);
            IOUtil.writeMap(out, this.extProperties);
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

