/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.base.Joiner;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueParserFormatter;

public abstract class ListParserFormatterSupport<E>
implements ValueParserFormatter<List<E>> {
    private final ValueParserFormatter<E> delegateParserFormatter;

    protected ListParserFormatterSupport(ValueParserFormatter<E> delegateParserFormatter) {
        this.delegateParserFormatter = delegateParserFormatter;
    }

    public List<E> parse(String value) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            String[] ids;
            for (String id : ids = value.split("\\|")) {
                Object entity = this.delegateParserFormatter.parse(id.trim());
                list.add(entity);
            }
        }
        return list;
    }

    public String format(List<E> entities) {
        ArrayList<String> ids = new ArrayList<String>();
        for (E entity : entities) {
            String id = this.delegateParserFormatter.format(entity);
            ids.add(id);
        }
        return Joiner.on((char)'|').join(ids);
    }
}

