/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.validation.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class EditCruiseInValidationUIAction
extends LongActionSupport<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    private final ValidateCruiseOperationsService validationService;
    protected Cruise cruise;
    protected final PropertyChangeListener modelListener = new PropertyChangeListener(){
        protected final List<String> propertiesToIgnore = Lists.newArrayList((Object[])new String[]{"valid", "persisted"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCruiseUIModel model = (EditCruiseUIModel)evt.getSource();
            if ("modify".equals(evt.getPropertyName())) {
                if (!model.isModify()) {
                    Cruise cruise = EditCruiseInValidationUIAction.this.getDataContext().reloadCruise();
                    ((ValidateCruiseUIModel)EditCruiseInValidationUIAction.this.getModel()).setCruise(cruise);
                }
            } else if (!this.propertiesToIgnore.contains(evt.getPropertyName())) {
                Cruise cruise = (Cruise)model.toEntity();
                NuitonValidatorResult validationResult = EditCruiseInValidationUIAction.this.validationService.validateCruiseCruise(cruise);
                ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)EditCruiseInValidationUIAction.this.getModel();
                uiModel.setCruiseValidatorResult(validationResult);
                ((ValidateCruiseUIHandler)EditCruiseInValidationUIAction.this.getHandler()).updateCurrentCruiseNode(validationResult);
            }
        }
    };

    public EditCruiseInValidationUIAction(ValidateCruiseUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.validateCruise.action.editCruise.tip", (Object[])new Object[0]));
        this.validationService = this.getContext().getValidateCruiseOperationsService();
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public boolean prepareAction() throws Exception {
        this.removeListener();
        return super.prepareAction();
    }

    public void removeListener() {
        EditCruiseUI operationPanel = ((ValidateCruiseUI)this.getUI()).getCruisePanel();
        operationPanel.getModel().removePropertyChangeListener(this.modelListener);
    }

    @Override
    public void doAction() throws Exception {
        ((ValidateCruiseUI)this.getUI()).getCruisePanel().getHandler().reloadCruise(this.cruise);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        EditCruiseUI cruisePanel = ((ValidateCruiseUI)this.getUI()).getCruisePanel();
        cruisePanel.getModel().addPropertyChangeListener(this.modelListener);
    }

    public void releaseAction() {
        super.releaseAction();
        this.cruise = null;
    }
}

