/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.MaturityColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class IndividualObservationBatchTableModel
extends AbstractApplicationTableModel<IndividualObservationBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> RANK = ColumnIdentifier.newId((String)"rankOrder", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.rank", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.rank.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SIZE = ColumnIdentifier.newId((String)"size", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.size.tip", (Object[])new Object[0]));
    public static final MaturityColumnIdentifier MATURITY = new MaturityColumnIdentifier();
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> OTHER_CARACTERISTICS = ColumnIdentifier.newId((String)"caracteristics", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SAMPLING_CODE = ColumnIdentifier.newId((String)"samplingCode", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.samplingCode", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.samplingCode.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> COMMENT = ColumnIdentifier.newId((String)"comment", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.comment", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.comment.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId((String)"attachment", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.file", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.file.tip", (Object[])new Object[0]));
    protected final WeightUnit weightUnit;
    protected final CaracteristicMap defaultCaracteristicsMap;
    protected Species species;
    protected Caracteristic lengthstepCaracteristic;
    private final SpeciesFrequencyUIModel uiModel;
    private final Function<IndividualObservationBatchRowModel, Void> installListenersOnRow;
    private final Function<IndividualObservationBatchRowModel, Void> uninstallListenersOnRow;
    private final IndividualObservationBatchUIModel model;

    public IndividualObservationBatchTableModel(WeightUnit weightUnit, SpeciesFrequencyUIModel uiModel, TableColumnModelExt columnModel, Function<IndividualObservationBatchRowModel, Void> installListenersOnRow, Function<IndividualObservationBatchRowModel, Void> uninstallListenersOnRow) {
        super(columnModel, true, true);
        this.uiModel = uiModel;
        this.installListenersOnRow = installListenersOnRow;
        this.uninstallListenersOnRow = uninstallListenersOnRow;
        this.model = uiModel.getIndividualObservationModel();
        this.weightUnit = weightUnit;
        this.defaultCaracteristicsMap = new CaracteristicMap();
        this.setNoneEditableCols(new ColumnIdentifier[]{RANK});
    }

    public void setSpecies(Species species) {
        this.species = species;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setSpecies(species));
        }
    }

    public void setLengthstepCaracteristic(Caracteristic lengthstepCaracteristic) {
        this.lengthstepCaracteristic = lengthstepCaracteristic;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setLengthStepCaracteristic(lengthstepCaracteristic));
        }
    }

    public void setDefaultCaracteristics(CaracteristicMap defaultCaracteristics) {
        this.defaultCaracteristicsMap.clear();
        this.defaultCaracteristicsMap.putAll(defaultCaracteristics);
    }

    public IndividualObservationBatchRowModel createNewRow() {
        IndividualObservationBatchRowModel result = new IndividualObservationBatchRowModel(this.weightUnit, this.defaultCaracteristicsMap);
        result.setCopyIndividualObservationMode(this.uiModel.getCopyIndividualObservationMode());
        result.setValid(false);
        result.setRankOrder(this.getRowCount() + 1);
        result.setSpecies(this.species);
        result.setLengthStepCaracteristic(this.lengthstepCaracteristic);
        if (this.getRowCount() > 0) {
            IndividualObservationBatchRowModel lastRow = (IndividualObservationBatchRowModel)this.getRows().get(this.getRowCount() - 1);
            CaracteristicQualitativeValue gender = this.model.getGender(lastRow);
            this.model.setGenderValueToDefaultCaracterictis(result, gender);
            if (this.model.withMaturityCaracteristic()) {
                CaracteristicQualitativeValue maturityState = this.model.getMaturityValue(lastRow);
                this.model.setMaturityValueToDefaultCaracterictis(result, maturityState);
            }
        }
        return result;
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<IndividualObservationBatchRowModel> columnIdentifier) {
        boolean editable;
        if (columnIdentifier instanceof MaturityColumnIdentifier) {
            MaturityColumnIdentifier maturityColumnIdentifier = (MaturityColumnIdentifier)columnIdentifier;
            editable = maturityColumnIdentifier.withCaracteristic();
            if (editable) {
                Serializable defaultValue = (Serializable)this.defaultCaracteristicsMap.get(maturityColumnIdentifier.getCaracteristic());
                editable = defaultValue == null;
            }
        } else {
            CaracteristicColumnIdentifier caracteristicColumnIdentifier;
            Caracteristic caracteristic;
            Serializable defaultValue;
            editable = columnIdentifier instanceof CaracteristicColumnIdentifier ? (defaultValue = (Serializable)this.defaultCaracteristicsMap.get(caracteristic = (caracteristicColumnIdentifier = (CaracteristicColumnIdentifier)columnIdentifier).getCaracteristic())) == null : (SAMPLING_CODE.equals(columnIdentifier) ? this.getValueAt(rowIndex, columnIndex) == null && this.getValueAt(rowIndex, this.identifiers.indexOf(SIZE)) != null : super.isCellEditable(rowIndex, columnIndex, columnIdentifier));
        }
        return editable;
    }

    public List<IndividualObservationBatchRowModel> loadRows(List<IndividualObservationBatchRowModel> individualObservations) {
        ArrayList<IndividualObservationBatchRowModel> obsRows = new ArrayList<IndividualObservationBatchRowModel>();
        if (CollectionUtils.isNotEmpty(individualObservations)) {
            CopyIndividualObservationMode copyIndividualObservationMode = null;
            int rankOrder = 1;
            for (IndividualObservationBatchRowModel rowModel : individualObservations) {
                CopyIndividualObservationMode incomingCopyIndividualObservationMode = rowModel.getCopyIndividualObservationMode();
                Objects.requireNonNull(incomingCopyIndividualObservationMode, "Mode de recopie non trouv\u00e9 sur l'observation individuelle: " + rowModel.getId());
                if (copyIndividualObservationMode == null) {
                    copyIndividualObservationMode = incomingCopyIndividualObservationMode;
                } else if (copyIndividualObservationMode != incomingCopyIndividualObservationMode) {
                    throw new IllegalStateException("Plusieurs modes de recopie trouv\u00e9s sur les observations individuelles du lot, ce qui est impossible");
                }
                IndividualObservationBatchRowModel newRow = this.createNewRow();
                newRow.copy(rowModel);
                newRow.setRankOrder(rankOrder++);
                newRow.setValid(true);
                this.model.moveGenderValueFromCaracteristicsToDefaultCaracteristics(newRow);
                this.model.moveMaturityValueFromCaracteristicsToDefaultCaracteristics(newRow);
                obsRows.add(newRow);
            }
        }
        return obsRows;
    }

    protected void onRowAdded(int rowIndex, IndividualObservationBatchRowModel row) {
        this.attachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
    }

    protected void onRowUpdated(int rowIndex, IndividualObservationBatchRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
        this.model.recomputeRowValidState(row);
    }

    protected void onRowRemoved(int rowIndex, IndividualObservationBatchRowModel row) {
        this.dettachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.recomputeRowsValidateState();
    }

    protected void onBeforeRowsChanged(List<IndividualObservationBatchRowModel> oldRows) {
        if (oldRows != null) {
            oldRows.forEach(this::dettachListeners);
        }
    }

    protected void onRowsChanged(List<IndividualObservationBatchRowModel> newRows) {
        int rankOrder = 1;
        for (IndividualObservationBatchRowModel row : newRows) {
            this.attachListeners(row);
            row.setRankOrder(rankOrder++);
        }
        newRows.forEach(this::attachListeners);
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.recomputeRowsValidateState();
    }

    public IndividualObservationBatchRowModel addRafaleRow(Float step) {
        IndividualObservationBatchRowModel row = this.getEmptyRow();
        if (row == null) {
            row = this.createNewRow();
            this.addNewRow(row);
        }
        row.setSize(step);
        this.updateRow(row);
        return row;
    }

    private IndividualObservationBatchRowModel getEmptyRow() {
        Set<Caracteristic> notNullCaracteristics;
        IndividualObservationBatchRowModel row;
        IndividualObservationBatchRowModel result = null;
        for (int i = this.rows.size() - 1; i >= 0 && (row = (IndividualObservationBatchRowModel)this.rows.get(i)).isEmpty(notNullCaracteristics = this.defaultCaracteristicsMap.keySet().stream().filter(key -> this.defaultCaracteristicsMap.get(key) != null).collect(Collectors.toSet())); --i) {
            result = row;
        }
        return result;
    }

    private void dettachListeners(IndividualObservationBatchRowModel result) {
        this.uninstallListenersOnRow.apply(result);
    }

    private void attachListeners(IndividualObservationBatchRowModel result) {
        this.dettachListeners(result);
        this.installListenersOnRow.apply(result);
    }
}

