/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningCount
extends AggrFunction {
    @Override
    public String getName() {
        return "RUNNINGCOUNT";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 2;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, true, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalRunningCount.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalRunningCount.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private int count;
        boolean countByColumn = true;

        private MyAccumulator() {
        }

        @Override
        public void start() throws DataException {
            this.count = 0;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            if (!this.countByColumn || args == null || args.length == 0) {
                if (this.countByColumn) {
                    this.countByColumn = false;
                }
                ++this.count;
            } else if (args.length > 0 && args[0] != null) {
                ++this.count;
            }
        }

        @Override
        public Object getValue() throws DataException {
            return this.count;
        }
    }
}

