/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public class DateVersions {
    private static final Log log = LogFactory.getLog(DateVersions.class);

    protected DateVersions() {
    }

    public static Date convertVersion2Date(Version version) {
        Preconditions.checkNotNull((Object)version);
        return DateVersions.convertVersion2Date(version.toString());
    }

    public static Date convertVersion2Date(String version) {
        Preconditions.checkNotNull((Object)version);
        String[] versionParts = Splitter.on((char)'.').splitToList((CharSequence)version).toArray(new String[4]);
        GregorianCalendar result = new GregorianCalendar();
        boolean parseError = false;
        try {
            int year = Integer.parseInt(versionParts[0]);
            result.set(1, year);
            int month = Integer.parseInt(versionParts[1]);
            result.set(2, month - 1);
            int day = Integer.parseInt(versionParts[2]);
            result.set(5, day);
            if (StringUtils.isBlank((CharSequence)versionParts[3])) {
                result.set(13, 0);
                result.set(12, 0);
                result.set(11, 0);
            } else {
                String time = versionParts[3];
                if (time.length() > 6) {
                    parseError = true;
                } else {
                    time = StringUtils.leftPad((String)time, (int)6, (char)'0');
                    int seconds = Integer.parseInt(time.substring(time.length() - 2));
                    result.set(13, seconds);
                    int minutes = Integer.parseInt(time.substring(time.length() - 4, time.length() - 2));
                    result.set(12, minutes);
                    int hours = Integer.parseInt(time.substring(0, time.length() - 4));
                    result.set(11, hours);
                }
            }
            result.set(14, 0);
        }
        catch (Exception ex) {
            parseError = true;
        }
        if (parseError) {
            throw new AdagioTechnicalException(String.format("the database version '%s' can't be converted to a synchronization date", version));
        }
        return result.getTime();
    }

    public static Date safeConvertVersion2Date(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        try {
            return DateVersions.convertVersion2Date(version);
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Version convertDate2Version(Date date) {
        Preconditions.checkNotNull((Object)date);
        String dateStr = new SimpleDateFormat("yyyy.MM.dd.HHmmss").format(date);
        Version version = Versions.valueOf((String)dateStr);
        return version;
    }
}

