/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    public void doAction() throws Exception {
        TuttiProtocol saved;
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = context.getPersistenceService();
        TuttiProtocol bean = model.toEntity();
        if (log.isInfoEnabled()) {
            log.info((Object)("bean zones " + bean.getZone()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        if (TuttiEntities.isNew((TuttiEntity)bean)) {
            saved = persistenceService.createProtocol(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = persistenceService.saveProtocol(bean);
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProtocolId(saved.getId());
        this.getDataContext().closeCruiseCache();
        model.setModify(false);
    }

    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProtocolUIHandler.getTitle(true));
        ((EditProtocolUI)this.getUI()).getSaveWarningContainer().setVisible(false);
    }
}

