/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.RowWithOperationContextSupport;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class GenericFormatImportCruiseContext
implements Closeable,
Iterable<GenericFormatImportOperationContext> {
    private final Cruise cruise;
    private final CruiseDataModel selectiontCruiseData;
    private final CruiseDataModel existingCruiseData;
    private final String cruiseLabel;
    private final Map<String, GenericFormatImportOperationContext> fishingOperationContexts;
    private final Set<Gear> gearsWithcaracteristics;
    private final Set<FishingOperation> existingOperations;
    private final Set<String> skippedFishingOperationsNaturalId;

    public GenericFormatImportCruiseContext(Cruise cruise, CruiseDataModel selectiontCruiseData, CruiseDataModel existingCruiseData, Set<FishingOperation> existingOperations, String cruiseLabel) {
        this.cruise = cruise;
        this.selectiontCruiseData = selectiontCruiseData;
        this.existingCruiseData = existingCruiseData;
        this.existingOperations = existingOperations == null ? Collections.emptySet() : existingOperations;
        this.cruiseLabel = cruiseLabel;
        this.fishingOperationContexts = new TreeMap<String, GenericFormatImportOperationContext>();
        this.gearsWithcaracteristics = new HashSet<Gear>();
        this.skippedFishingOperationsNaturalId = new LinkedHashSet<String>();
    }

    public Iterable<GenericFormatImportOperationContext> orderedFishingOperationContexts() {
        return Ordering.from((Comparator)FishingOperations.FISHING_OPERATION_COMPARATOR).onResultOf((Function)new Function<GenericFormatImportOperationContext, FishingOperation>(){

            public FishingOperation apply(GenericFormatImportOperationContext input) {
                return input.getFishingOperation();
            }
        }).sortedCopy(this.fishingOperationContexts.values());
    }

    @Override
    public void close() {
        this.fishingOperationContexts.values().forEach(GenericFormatImportOperationContext::close);
        this.fishingOperationContexts.clear();
    }

    @Override
    public Iterator<GenericFormatImportOperationContext> iterator() {
        return ImmutableList.copyOf(this.fishingOperationContexts.values()).iterator();
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public CruiseDataModel getExistingCruiseData() {
        return this.existingCruiseData;
    }

    public OperationDataModel getExistingFishingOperationData(FishingOperation importRowCruise) {
        OperationDataModel result = null;
        String fishingOperationId = this.getExistingFishingOperationId(importRowCruise);
        if (fishingOperationId != null) {
            for (OperationDataModel operationDataModel : this.existingCruiseData) {
                if (!fishingOperationId.equals(operationDataModel.getId())) continue;
                result = operationDataModel;
                break;
            }
        }
        return result;
    }

    public String getCruiseLabel() {
        return this.cruiseLabel;
    }

    public Gear getGear(Gear gear, int rankOrder) {
        GearWithOriginalRankOrder cruiseGear;
        boolean gearExists;
        GearWithOriginalRankOrder result = null;
        int index = rankOrder - 1;
        boolean bl = gearExists = this.cruise.sizeGear() > index;
        if (gearExists && (gearExists = (cruiseGear = this.cruise.getGear(index)).getId().equals(gear.getId()))) {
            result = cruiseGear;
        }
        return result;
    }

    public void addFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch, String fishingOperationLabel) {
        OperationDataModel existingFishingOperationData = this.getExistingFishingOperationData(fishingOperation);
        this.fishingOperationContexts.put(fishingOperation.getId(), new GenericFormatImportOperationContext(fishingOperation, catchBatch, existingFishingOperationData, fishingOperationLabel));
    }

    public void addSkippedFishingOperation(FishingOperation fishingOperation) {
        String naturalId = FishingOperations.getNaturalId((FishingOperation)fishingOperation);
        this.skippedFishingOperationsNaturalId.add(naturalId);
    }

    public boolean isFishingOperationSkipped(RowWithOperationContextSupport row) {
        FishingOperation fishingOperation = row.getFishingOperation();
        String naturalId = FishingOperations.getNaturalId((FishingOperation)fishingOperation);
        return this.skippedFishingOperationsNaturalId.contains(naturalId);
    }

    public boolean isFishingOperationAlreadyImported(RowWithOperationContextSupport row) {
        GenericFormatImportOperationContext fishingOperationContext = this.getFishingOperationContext(row);
        return fishingOperationContext != null;
    }

    public OperationDataModel getSelectedFishingOperation(FishingOperation row) {
        OperationDataModel result = null;
        for (OperationDataModel selectedFishingOperation : this.selectiontCruiseData) {
            boolean equals = FishingOperations.equalsNaturalId((FishingOperation)row, (String)selectedFishingOperation.getId());
            if (!equals) continue;
            result = selectedFishingOperation;
            break;
        }
        return result;
    }

    public GenericFormatImportOperationContext getFishingOperationContext(RowWithOperationContextSupport row) {
        FishingOperation fishingOperation = row.getFishingOperation();
        GenericFormatImportOperationContext result = null;
        for (GenericFormatImportOperationContext importOperationContext : this.fishingOperationContexts.values()) {
            FishingOperation importedFishingOperation = importOperationContext.getFishingOperation();
            boolean equals = FishingOperations.equals((FishingOperation)importedFishingOperation, (FishingOperation)fishingOperation);
            if (!equals) continue;
            result = importOperationContext;
            break;
        }
        return result;
    }

    public Iterable<FishingOperation> getFishingOperations() {
        return this.fishingOperationContexts.values().stream().map(arg_0 -> GenericFormatImportOperationContext.TO_FISHING_OPERATION_FUNCTION.apply(arg_0)).collect(Collectors.toList());
    }

    public boolean withGearCaracteristics() {
        return !this.gearsWithcaracteristics.isEmpty();
    }

    public void addGearCaracteristic(Gear gear, Caracteristic caracteristic, Serializable caracteristicValue) {
        this.gearsWithcaracteristics.add(gear);
        CaracteristicMap caracteristics = gear.getCaracteristics();
        if (caracteristics == null) {
            caracteristics = new CaracteristicMap();
            gear.setCaracteristics(caracteristics);
        }
        caracteristics.put(caracteristic, caracteristicValue);
    }

    public Set<Gear> getGearsWithcaracteristics() {
        return this.gearsWithcaracteristics;
    }

    protected String getExistingFishingOperationId(FishingOperation importRowCruise) {
        String result = null;
        for (FishingOperation fishingOperation : this.existingOperations) {
            boolean equals = FishingOperations.equals((FishingOperation)importRowCruise, (FishingOperation)fishingOperation);
            if (!equals) continue;
            result = fishingOperation.getId();
            break;
        }
        return result;
    }
}

