/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.maturity;

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jdesktop.beans.AbstractSerializableBean;

public class EditMaturityCaracteristicPopupUIModel
extends AbstractSerializableBean {
    public static final String PROPERTY_ALL_MATURITY_STATES = "allMaturityStates";
    public static final String PROPERTY_MATURE_STATE_IDS = "matureStateIds";
    protected boolean valid;
    protected final List<CaracteristicQualitativeValue> allMaturityStates = new ArrayList<CaracteristicQualitativeValue>();
    protected final Collection<String> matureStateIds = new HashSet<String>();

    public List<CaracteristicQualitativeValue> getAllMaturityStates() {
        return this.allMaturityStates;
    }

    public void setAllMaturityStates(List<CaracteristicQualitativeValue> allMaturityStates) {
        this.allMaturityStates.clear();
        if (allMaturityStates != null) {
            this.allMaturityStates.addAll(allMaturityStates);
        }
        this.firePropertyChange(PROPERTY_ALL_MATURITY_STATES, null, this.allMaturityStates);
    }

    public Collection<String> getMatureStateIds() {
        return this.matureStateIds;
    }

    public void setMatureStateIds(Collection<String> matureStateIds) {
        this.matureStateIds.clear();
        if (matureStateIds != null) {
            this.matureStateIds.addAll(matureStateIds);
        }
        this.firePropertyChange(PROPERTY_MATURE_STATE_IDS, null, this.matureStateIds);
    }

    public void addMatureState(CaracteristicQualitativeValue state) {
        Objects.requireNonNull(state);
        this.addMatureState(state.getId());
    }

    public void addMatureState(String stateId) {
        this.matureStateIds.add(stateId);
        this.firePropertyChange(PROPERTY_MATURE_STATE_IDS, null, this.matureStateIds);
    }

    public void removeMatureState(CaracteristicQualitativeValue state) {
        Objects.requireNonNull(state);
        this.removeMatureState(state.getId());
    }

    public void removeMatureState(String stateId) {
        this.matureStateIds.remove(stateId);
        this.firePropertyChange(PROPERTY_MATURE_STATE_IDS, null, this.matureStateIds);
    }

    public boolean isMature(CaracteristicQualitativeValue state) {
        Objects.requireNonNull(state);
        return this.isMature(state.getId());
    }

    public boolean isMature(String id) {
        return this.matureStateIds.contains(id);
    }

    public boolean hasMatureValues() {
        return this.matureStateIds.size() > 0;
    }

    public boolean hasImmatureValues() {
        return this.matureStateIds.size() < this.allMaturityStates.size();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

