/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.actions;

import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;

public class SaveGenericFormatImportReportAction
extends LongActionSupport<GenericFormatImportUIModel, GenericFormatImportUI, GenericFormatImportUIHandler> {
    private static final DateFormat DF = new SimpleDateFormat("yyy-MM-dd-hh-mm");
    private File targetFile;

    public SaveGenericFormatImportReportAction(GenericFormatImportUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            boolean bl = doAction = ((GenericFormatImportUIModel)this.getModel()).getImportReportFile() != null && ((GenericFormatImportUIModel)this.getModel()).getImportReportFile().exists();
        }
        if (doAction) {
            this.targetFile = this.saveFileWithStartDirectory(this.getConfig().getGenericFormatReportBackupDirectory(), false, "import-report-" + ((GenericFormatImportUIModel)this.getModel()).getProgram().getId() + "-" + DF.format(new Date()), "pdf", I18n.t((String)"tutti.genericFormat.title.choose.saveImportReportfile", (Object[])new Object[0]), I18n.t((String)"tutti.genericFormat.action.chooseImportReportFile", (Object[])new Object[0]), new String[]{"^.+\\.pdf", I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0])});
            doAction = this.targetFile != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        File reportFile = ((GenericFormatImportUIModel)this.getModel()).getImportReportFile();
        ApplicationIOUtil.copyFile((File)reportFile, (File)this.targetFile, (String)I18n.t((String)"tutti.io.error.copyFile", (Object[])new Object[0]));
        this.sendMessage(I18n.t((String)"tutti.genericFormat.importReportFile.saved", (Object[])new Object[]{this.targetFile}));
    }

    protected void releaseAction() {
        this.targetFile = null;
        super.releaseAction();
    }
}

