/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import java.util.ArrayList;
import java.util.List;

public class CreateOperationRowsAction
extends ExportFishingOperationActionSupport {
    private final PersistenceService persistenceService;

    public CreateOperationRowsAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public boolean doExecute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        return true;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        FishingOperation operation = operationContext.getOperation();
        Cruise cruise = operationContext.getCruise();
        CatchBatch catchBatch = operationContext.getCatchBatch();
        boolean exportSpecies = exportContext.isExportSpecies();
        boolean exportBenthos = exportContext.isExportBenthos();
        boolean exportMarineLitter = exportContext.isExportMarineLitter();
        OperationRow operationRow = exportContext.getProducerForOperation().getDataToExport(cruise, operation, catchBatch);
        operationRow.computeCatchValues(exportSpecies, exportBenthos, exportMarineLitter);
        operationContext.setOperationRow(operationRow);
        if (exportContext.isExportAttachments()) {
            List<AttachmentRow> attachmentRows = this.getAttachmentRows(exportContext, operation, catchBatch);
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    protected List<AttachmentRow> getAttachmentRows(GenericFormatExportContext exportContext, FishingOperation operation, CatchBatch catchBatch) {
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.OPERATION, operation.getIdAsInt());
        producerForAttachment.addAttachments(attachments, attachmentRows);
        if (catchBatch != null) {
            attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.CATCH_BATCH, catchBatch.getIdAsInt());
            producerForAttachment.addAttachments(attachments, attachmentRows);
        }
        return attachmentRows;
    }
}

