/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CaracteristicValueParseException;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.ParameterModel;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import java.io.Serializable;
import java.nio.file.Path;
import org.nuiton.csv.ImportRow;

public class CsvConsumerForParameter
extends CsvComsumer<ParameterRow, ParameterModel> {
    public CsvConsumerForParameter(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, ParameterModel.forImport(separator, parserFactory), reportError);
    }

    public GenericFormatImportOperationContext validateRow(ImportRow<ParameterRow> row, GenericFormatContextSupport importContext) {
        GenericFormatImportOperationContext operationContext = importContext.getValidationHelper().getFishingOperationContext(this, row, importContext);
        if (operationContext != null) {
            Caracteristic caracteristic;
            ParameterRow bean = (ParameterRow)row.getBean();
            bean.setFishingOperation(operationContext.getFishingOperation());
            if (bean.getParameterType() == null) {
                // empty if block
            }
            if ((caracteristic = bean.getCaracteristic()) == null) {
                // empty if block
            }
            if (bean.getValue() == null) {
                // empty if block
            }
            String value = (String)((Object)bean.getValue());
            try {
                Serializable serializable = importContext.parseCaracteristicValue(caracteristic, value);
                bean.setValue(serializable);
            }
            catch (CaracteristicValueParseException e) {
                this.addCheckError(row, e);
            }
        }
        this.reportError(row);
        return operationContext;
    }

    public void prepareRowForPersist(GenericFormatImportOperationContext operationContext, ImportRow<ParameterRow> row) {
        ParameterRow bean = (ParameterRow)row.getBean();
        ParameterRow.ParameterType parameterType = bean.getParameterType();
        switch (parameterType) {
            case GEAR: {
                operationContext.addGearUseFeature(bean.getCaracteristic(), bean.getValue());
                break;
            }
            case VESSEL: {
                operationContext.addVesselUseFeature(bean.getCaracteristic(), bean.getValue());
            }
        }
    }
}

