/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.action.ApplicationActionException;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;
import org.nuiton.jaxx.application.swing.util.ApplicationExceptionHandler;

public class TuttiExceptionHandler
extends ApplicationExceptionHandler {
    private static final Log log = LogFactory.getLog(TuttiExceptionHandler.class);

    public TuttiExceptionHandler(ApplicationErrorHelper errorHelper) {
        super(errorHelper);
    }

    public void uncaughtException(Thread t, Throwable ex) {
        if (t.getName().startsWith("AWT-EventQueue-")) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Swallow Swing error: " + ex.getMessage()), ex);
            }
        } else {
            super.uncaughtException(t, ex);
        }
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Global application exception [" + tname + "]"), ex);
        }
        Throwable cause = this.getCause(ex);
        boolean backToScreen = false;
        LongActionSupport action = null;
        if (cause instanceof ApplicationActionException) {
            ApplicationActionException actionException = (ApplicationActionException)cause;
            cause = cause.getCause();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Action error cause:", cause);
            }
            if ((action = (LongActionSupport)actionException.getAction()) instanceof AbstractChangeScreenAction) {
                backToScreen = true;
            }
        }
        this.showErrorDialog(cause.getMessage(), cause);
        if (backToScreen) {
            action.getContext().setFallBackScreen();
        }
    }

    protected Throwable getCause(Throwable ex) {
        Throwable cause = super.getCause(ex);
        if (cause == null && ex instanceof ApplicationTechnicalException) {
            cause = ex;
        }
        return cause;
    }
}

