/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.update.module;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.TuttiConfigurationOption;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.update.module.ModuleUpdaterSupport;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class TuttiModuleUpdater
extends ModuleUpdaterSupport {
    private static final Log log = LogFactory.getLog(TuttiModuleUpdater.class);

    public TuttiModuleUpdater() {
        super(UpdateModule.tutti);
    }

    @Override
    protected void onUpdateToDo(TuttiUIContext context, ApplicationInfo info) {
        if (info != null && log.isInfoEnabled()) {
            log.info((Object)("Find a updatable module : " + this.updateModule));
        }
    }

    @Override
    public void onUpdateDone(TuttiUIContext context, ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("A tutti update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
        }
        TuttiConfiguration config = context.getConfig();
        File cacheDirectory = config.getCacheDirectory();
        ApplicationIOUtil.forceDeleteOnExit((File)cacheDirectory, (String)I18n.t((String)"tutti.applicationUpdater.updateDone.deleteDirectory.caches.error", (Object[])new Object[]{cacheDirectory}));
        Version oldVersion = Versions.valueOf((String)info.oldVersion);
        if (config.isFullLaunchMode() && oldVersion.before(Versions.valueOf((String)"3.7.1"))) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove from configuration tutti.update.application.url: " + config.getUpdateApplicationUrl()));
            }
            config.getApplicationConfig().setOption(TuttiConfigurationOption.UPDATE_APPLICATION_URL.getKey(), "");
            config.save();
        }
    }

    @Override
    public String getLabel() {
        return I18n.t((String)"tutti.update.tutti", (Object[])new Object[0]);
    }
}

