/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.rtp;

import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.RtpBean;
import fr.ifremer.tutti.persistence.entities.protocol.Rtps;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RtpEditorUIModel
extends AbstractTuttiBeanUIModel<EditProtocolSpeciesRowModel, RtpEditorUIModel> {
    private static final Log log = LogFactory.getLog(RtpEditorUIModel.class);
    public static final String PROPERTY_RTP_MALE_A = "rtpMaleA";
    public static final String PROPERTY_RTP_MALE_B = "rtpMaleB";
    public static final String PROPERTY_RTP_FEMALE_A = "rtpFemaleA";
    public static final String PROPERTY_RTP_FEMALE_B = "rtpFemaleB";
    public static final String PROPERTY_RTP_UNDEFINED_A = "rtpUndefinedA";
    public static final String PROPERTY_RTP_UNDEFINED_B = "rtpUndefinedB";
    public static final String PROPERTY_FIRST_ROW = "firstRow";
    public static final String PROPERTY_LAST_ROW = "lastRow";
    public static final String PROPERTY_ROW = "row";
    protected final Rtp rtpMale = new RtpBean();
    protected final Rtp rtpFemale = new RtpBean();
    protected final Rtp rtpUndefined = new RtpBean();
    protected boolean firstRow;
    protected boolean lastRow;
    protected EditProtocolSpeciesTableModel tableModel;
    protected List<Integer> rows = new ArrayList<Integer>();
    protected int row = -1;

    public RtpEditorUIModel() {
        super(null, null);
    }

    @Override
    protected EditProtocolSpeciesRowModel newEntity() {
        return null;
    }

    public Rtp getRtpMale() {
        return this.rtpMale;
    }

    public Rtp getRtpUndefined() {
        return this.rtpUndefined;
    }

    public Rtp getRtpFemale() {
        return this.rtpFemale;
    }

    public Double getRtpMaleA() {
        return this.rtpMale.getA();
    }

    public void setRtpMaleA(Double a) {
        this.rtpMale.setA(a);
        this.firePropertyChanged(PROPERTY_RTP_MALE_A, null, a);
    }

    public Float getRtpMaleB() {
        return this.rtpMale.getB();
    }

    public void setRtpMaleB(Float b) {
        this.rtpMale.setB(b);
        this.firePropertyChanged(PROPERTY_RTP_MALE_B, null, b);
    }

    public Double getRtpFemaleA() {
        return this.rtpFemale.getA();
    }

    public void setRtpFemaleA(Double a) {
        this.rtpFemale.setA(a);
        this.firePropertyChanged(PROPERTY_RTP_FEMALE_A, null, a);
    }

    public Float getRtpFemaleB() {
        return this.rtpFemale.getB();
    }

    public void setRtpFemaleB(Float b) {
        this.rtpFemale.setB(b);
        this.firePropertyChanged(PROPERTY_RTP_FEMALE_B, null, b);
    }

    public Double getRtpUndefinedA() {
        return this.rtpUndefined.getA();
    }

    public void setRtpUndefinedA(Double a) {
        this.rtpUndefined.setA(a);
        this.firePropertyChanged(PROPERTY_RTP_UNDEFINED_A, null, a);
    }

    public Float getRtpUndefinedB() {
        return this.rtpUndefined.getB();
    }

    public void setRtpUndefinedB(Float b) {
        this.rtpUndefined.setB(b);
        this.firePropertyChanged(PROPERTY_RTP_UNDEFINED_B, null, b);
    }

    public boolean isFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(boolean firstRow) {
        Boolean oldValue = this.isFirstRow();
        this.firstRow = firstRow;
        this.firePropertyChange(PROPERTY_FIRST_ROW, oldValue, firstRow);
    }

    public boolean isLastRow() {
        return this.lastRow;
    }

    public void setLastRow(boolean lastRow) {
        Boolean oldValue = this.isLastRow();
        this.lastRow = lastRow;
        this.firePropertyChange(PROPERTY_LAST_ROW, oldValue, lastRow);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        Integer oldValue = this.getRow();
        this.row = row;
        this.firePropertyChange(PROPERTY_ROW, oldValue, row);
    }

    public void setRowModel(EditProtocolSpeciesTableModel tableModel, RowSorter rowSorter, int row) {
        this.tableModel = tableModel;
        this.rows.clear();
        int rowIndex = 0;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            int rowIndexInModel = rowSorter.convertRowIndexToModel(i);
            EditProtocolSpeciesRowModel rowModel = (EditProtocolSpeciesRowModel)((Object)tableModel.getEntry(rowIndexInModel));
            if (rowModel.getLengthStepPmfm() == null) continue;
            this.rows.add(rowIndexInModel);
            if (row != i) continue;
            rowIndex = this.rows.size() - 1;
        }
        this.setRowModel(rowIndex);
    }

    public void setRowModel(int row) {
        if (log.isInfoEnabled()) {
            log.info((Object)("setRowModel " + row));
        }
        this.setRow(row);
        this.setFirstRow(row == 0);
        this.setLastRow(row == this.rows.size() - 1);
        EditProtocolSpeciesRowModel rowModel = this.getRowModel();
        Rtp rtpMale = rowModel.getRtpMale();
        this.setRtpMaleA(rtpMale == null ? null : rtpMale.getA());
        this.setRtpMaleB(rtpMale == null ? null : rtpMale.getB());
        Rtp rtpFemale = rowModel.getRtpFemale();
        this.setRtpFemaleA(rtpFemale == null ? null : rtpFemale.getA());
        this.setRtpFemaleB(rtpFemale == null ? null : rtpFemale.getB());
        Rtp rtpUndefined = rowModel.getRtpUndefined();
        this.setRtpUndefinedA(rtpUndefined == null ? null : rtpUndefined.getA());
        this.setRtpUndefinedB(rtpUndefined == null ? null : rtpUndefined.getB());
        this.setModify(false);
    }

    public EditProtocolSpeciesRowModel getRowModel() {
        int rowIndex = this.rows.get(this.row);
        return (EditProtocolSpeciesRowModel)((Object)this.tableModel.getEntry(rowIndex));
    }

    public void reset() {
        this.setRowModel(this.row);
    }

    public void updateRowRtp() {
        EditProtocolSpeciesRowModel rowModel = this.getRowModel();
        rowModel.setRtpMale(Rtps.newRtp((Rtp)this.getRtpMale()));
        rowModel.setRtpFemale(Rtps.newRtp((Rtp)this.getRtpFemale()));
        rowModel.setRtpUndefined(Rtps.newRtp((Rtp)this.getRtpUndefined()));
        this.setModify(false);
        this.tableModel.fireTableRowsUpdated(this.row, this.row);
    }
}

