package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplaceTemporarySpeciesUI extends AbstractReplaceTemporaryUI<Species, ReplaceTemporarySpeciesUIModel> implements TuttiUI<ReplaceTemporarySpeciesUIModel, ReplaceTemporarySpeciesUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TTU8UQRCtXd2FBVFgA8GICYrx2OuFg2KUD7MRsohhISHuQXtnGrbJ7EzbXSNDjMaf4E/QuxcTb56MB88evBj/gjEevBqrZ4f9gEGIcQ+VTVXXq1c17735Djmj4dIOjyKmQx9lU7Dl+c3N1fqOcPCOMI6WCgMNrV8mC9kaDLrtvEGYrlVseylpLy0GTRX4wu/qnq3AgME9T5iGEIhwsbfDMaZUbZdnIxXqfdQ2qTTUVz9/ZF+6L15nASJF7OwqU8d1dTY5XYGsdBFGadITXvK4v000tPS3ie+QzS163Jh7vCkew3Poq0BecU1gCJdPvnKMEfdHCmFMC+VxR6wL6tBc720srQeUX93STG5p0RSaYYgoWSiZ2SUuzAl8JGimxZaw0yX3WILC1g6gVZVwpDAbS0rFM/MIuWbgCg9h/T9PWLGwnTGjJgi1IyrSIF2jHiwEEcJMz8doDROupPOwuuA+W6BQlh4Kzet0qaTPIhY6wMj1tsBuYFsZ6X01lPBdoM1oGyjazxclI5db2aRDw4UeWqQ+1lFfRx6ZGuR0SGmEidphwa5RqSXViQNStYBx9fd48cv7b+/K3focS33aZS/SjdKBEhqlHX2uJc4QpVda4Wq2BgUjPPJm7L3JFGLVpEzkaN6IbWe2nd3lpkEQub6vHz6OP/p8CrJlGPAC7pa5fb8EBWxoukLguZG6PRczOrPbT3HYckPIN4TcbpD8szPXIlp8MmXx9vR64dOvYvXt3P7yGSJz/sjnnQPkHkBe+p70RWzPxHmpdhxURoRu0HFYmudAKfLXYD2WwH3uCy+uTMZxKm3NHEr0SAnTLZscdGziABa/ikILcyXez/67Ckd5XCVe+cvg0YdcKU86HGXgzzs2IjhP/824PO43Rxm4Bc8ce6lnaVv0OuoE7Putpdf3FF3u7E2XI5+qS98lmrcOwWdsHD4W06av23AjHaFICH8A2H5AmMIGAAA=";
    private static final Log log = LogFactory.getLog(ReplaceTemporarySpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final ReplaceTemporarySpeciesUIHandler handler = createHandler();
    protected ReplaceTemporarySpeciesUIModel model;
    protected JButton replaceButton;
    protected ReplaceTemporarySpeciesUI replaceTemporaryUITop = this;
    protected BeanFilterableComboBox<Species> sourceListComboBox;
    protected BeanFilterableComboBox<Species> targetListComboBox;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporarySpeciesUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI() {
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporarySpeciesUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporarySpeciesUIHandler getHandler() {
        return handler;
    }

    public ReplaceTemporarySpeciesUIModel getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<Species> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public BeanFilterableComboBox<Species> getTargetListComboBox() {
        return targetListComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(sourceListComboBox);
        add(targetListComboBox);
        add(replaceButton);
    }

    protected ReplaceTemporarySpeciesUIHandler createHandler() {
        return new ReplaceTemporarySpeciesUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplaceTemporarySpeciesUIModel.class));
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.replace.actions.ReplaceTemporarySpeciesAction.class);
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<Species>());
        
        sourceListComboBox.setName("sourceListComboBox");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<Species>());
        
        targetListComboBox.setName("targetListComboBox");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        
        // apply 2 property setters
        sourceListComboBox.setBeanType(Species.class);
        targetListComboBox.setBeanType(Species.class);
        // late initializer
        replaceTemporaryUITop.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createSourceListComboBox();
        createTargetListComboBox();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        setTitle(t("tutti.replaceTemporarySpecies.title"));
        
        $completeSetup();
        handler.afterInit(this);
    }

}