package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public abstract class AbstractReplaceTemporaryUI<E extends TuttiReferentialEntity, M extends AbstractReplaceTemporaryUIModel<E>> extends JDialog implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_CHECK_BOX_SELECTED = "deleteCheckBox.selected";
    public static final String BINDING_REPLACE_BUTTON_ENABLED = "replaceButton.enabled";
    public static final String BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM = "sourceListComboBox.selectedItem";
    public static final String BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM = "targetListComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XS28cRRBuL34/4sTGJpAgBRNQAGnWhCQYOQqxHVnYWhPLu0ZR9mB6Z8reDr0zQ3dvPNYqiJ/AT4A7F6Rw4oQ4cObABfEXEOLAFVHdMzuzszurfcSRMrK6qr76+qvq6t7v/yJjUpA3ntAgsETdVawG1u7Go0cPK0/AVg9A2oL5yhMk/DeSI7kymXHidanIm+WCDs9H4fktr+Z7Lrgt0esFMi3VGQdZBVCKvJ6OsKXMF2PzeuDXRRM1JpWF+u0/f+e+cb7+LkdI4CO7OdzKtV5RyU5GCyTHHEUWMNNTmufUPUEagrknyHdOr21xKuWntAZfkq/IRIGM+1QgmCIr/W/ZYJj4wFdkSYDPqQ0lwAhBxdnhTsnD9f1jYbFjATUQlqorxaw6s+QpcrFsz1UIbQk4Bp2dUW5FKNZGRSpBbXXQger7Jum4ImM1zwGuyOF5p9jTuEmeqaeUM4fi3hV5L1WF2BClK+rvZ83FFqaKVjgocjkVHcaUtEn7TcXu89KrCxsKTKoCregtLuiiBVHErlnUvgtxyEISgjWreJteoMjtjHTgMM23AtS1NvGzzbgCoTk049LA84qKE1AxF738SlvuxKUV47W01wXUFBRsVcH+wrBbSu2puZ4Omr2+WwTsTS3nqiLLqZDYko6ZvL67T13gq+2ymdU2fJu6NvBN7BrsFLKY8g9XtedbccBc1D2J7d3IQZArKbnx7FvJ2U8O50iZjIk6LmM7lDvHxQGawkFxuW1QaEBj/W958fef/ny+3ZwOs5h7KdO1ZbjhqfWF54NQTKeeD0dDXTGe36P+eplMSayPHU6+qxnEipEZyWG+Szrc0uHWJ1RWEWJs4o+ff1n+/LeXSG6bTHOPOttU+++QKVUVqILHncD/+L5hNHs6id+L+D+H5wttpwcg9QAdVaKOao3q/sTyNLCvzGm88c6zADW5mqFJTKwy9eu/i8Uf7jd1GUGer3Z1T7QZe0zGmcuZC2ZuRiMxc07O+BLqjpeMvqxhSHDsLWefrWgk3DTfOx1ijCgyXgV2UkUlcrdXg7p2u2u2ov+6R3wfsWcqpvlMO/eC0zOS8kjXTrxuc9vvQXQUjxnX42BbD8WXG53T55nOCQFu5GY4k9vzHLSM5GMG3LESEOR9VMURrMh6Y2XwcEvHriCDGeV5vMT8kiFyZwgkxfws1dondB96zYbnC5wdBTVFrjTM7WVhgxcjQ9FgYqejuNFZPcO5KVNmzH0UXzvR7fBRQ90YQqYVnek8hM5SKONCGrSpOq+VIZoqARlqr0n4izZVC1K3pmq7as+lqUoGs2tTheYXbqqE+bBN1SF0ZlN1tkQfIkUtY/VLJXyoJLv4sP9dhKFxq0w2ZUbqUWmYfGB8TEXSrdR3T0dZurRR20Orl0D6FcTeX3P3XKh5LrOx8r154M3OPDd+Stfi2OnQsqMf3mQissclWB0UOSnCrW5F2AchMaCNUfZhvTXwzlBj3Ae4+hLHKl6Kq2he+eZV0lmB9CNx8AKs9U0zfL520388NMfy5wfETdRf6+cIpDllV+CDQWFMAeaOJKv5HDaMSZHHjeF+8oXQ0trinoTod9/hzkaUUD/hMuuZ+pXQq5z6DcfpmYfO5MJdnKj0WoW5DlK714E9or/TPRH18nP9+TEb4W1E+B+wTGTN8RAAAA==";
    private static final Log log = LogFactory.getLog(AbstractReplaceTemporaryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected JCheckBox deleteCheckBox;
    protected AbstractReplaceTemporaryUIModel<E> model;
    protected JButton replaceButton;
    protected AbstractReplaceTemporaryUI<E, M> replaceTemporaryUITop = this;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedSource",  editorName = "sourceListComboBox")
    protected BeanFilterableComboBox<E> sourceListComboBox;
    protected JLabel sourceListLabel;
    protected Table table;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedTarget",  editorName = "targetListComboBox")
    protected BeanFilterableComboBox<E> targetListComboBox;
    protected JLabel targetListLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<AbstractReplaceTemporaryUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbstractReplaceTemporaryUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI() {
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AbstractReplaceTemporaryUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__deleteCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDelete(event.getStateChange() == ItemEvent.SELECTED);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JCheckBox getDeleteCheckBox() {
        return deleteCheckBox;
    }

    public AbstractReplaceTemporaryUIModel<E> getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<E> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public JLabel getSourceListLabel() {
        return sourceListLabel;
    }

    public Table getTable() {
        return table;
    }

    public BeanFilterableComboBox<E> getTargetListComboBox() {
        return targetListComboBox;
    }

    public JLabel getTargetListLabel() {
        return targetListLabel;
    }

    public SwingValidator<AbstractReplaceTemporaryUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(table, BorderLayout.CENTER);
    }

    protected void addChildrenToTable() {
        if (!allComponentsCreated) {
            return;
        }
        table.add(sourceListLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(sourceListComboBox), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add(targetListLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        table.add(SwingUtil.boxComponentWithJxLayer(targetListComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add(deleteCheckBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JSeparator0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        table.add($JPanel0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.replaceTemporaryReferential.action.cancel"));
        cancelButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.replaceTemporaryReferential.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.referential.replace.actions.CloseReplaceUIAction.class);
    }

    protected void createDeleteCheckBox() {
        $objectMap.put("deleteCheckBox", deleteCheckBox = new JCheckBox());
        
        deleteCheckBox.setName("deleteCheckBox");
        deleteCheckBox.setText(t("tutti.replaceTemporaryReferential.field.delete"));
        deleteCheckBox.setToolTipText(t("tutti.replaceTemporaryReferential.field.delete.tip"));
        deleteCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__deleteCheckBox"));
        deleteCheckBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.delete.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.setText(t("tutti.replaceTemporaryReferential.action.replace"));
        replaceButton.setToolTipText(t("tutti.replaceTemporaryReferential.action.replace.tip"));
        replaceButton.putClientProperty("help", "tutti.replaceTemporaryPerson.action.replace.help");
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<E>(this));
        
        sourceListComboBox.setName("sourceListComboBox");
        sourceListComboBox.setProperty("selectedSource");
        sourceListComboBox.setShowReset(true);
        sourceListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
        sourceListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.sourceList"));
    }

    protected void createSourceListLabel() {
        $objectMap.put("sourceListLabel", sourceListLabel = new JLabel());
        
        sourceListLabel.setName("sourceListLabel");
        sourceListLabel.setText(t("tutti.replaceTemporaryReferential.field.sourceList"));
        sourceListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.sourceList.tip"));
        sourceListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.sourceList.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new Table());
        
        table.setName("table");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<E>(this));
        
        targetListComboBox.setName("targetListComboBox");
        targetListComboBox.setProperty("selectedTarget");
        targetListComboBox.setShowReset(true);
        targetListComboBox.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
        targetListComboBox.putClientProperty("validatorLabel", t("tutti.replaceTemporaryReferential.field.targetList"));
    }

    protected void createTargetListLabel() {
        $objectMap.put("targetListLabel", targetListLabel = new JLabel());
        
        targetListLabel.setName("targetListLabel");
        targetListLabel.setText(t("tutti.replaceTemporaryReferential.field.targetList"));
        targetListLabel.setToolTipText(t("tutti.replaceTemporaryReferential.field.targetList.tip"));
        targetListLabel.putClientProperty("help", "tutti.replaceTemporaryReferential.field.targetList.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AbstractReplaceTemporaryUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        addChildrenToValidator();
        addChildrenToTable();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(replaceButton);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        sourceListLabel.setLabelFor(sourceListComboBox);
        sourceListComboBox.setBean(getModel());
        targetListLabel.setLabelFor(targetListComboBox);
        targetListComboBox.setBean(getModel());
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        replaceButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.replaceTemporaryReferential.action.replace.mnemonic"),'Z'));
        replaceButton.setIcon(SwingUtil.createActionIcon("replace"));
        // late initializer
        replaceTemporaryUITop.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createValidator();
        createTable();
        createSourceListLabel();
        createSourceListComboBox();
        createTargetListLabel();
        createTargetListComboBox();
        createDeleteCheckBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        replaceTemporaryUITop.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSource", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sourceListComboBox.setSelectedItem(model.getSelectedSource());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSource", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TARGET_LIST_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedTarget", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    targetListComboBox.setSelectedItem(model.getSelectedTarget());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedTarget", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("delete", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteCheckBox.setSelected(model.isDelete());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("delete", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}